/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.integration.gregtech.handlerproxy;

import gregtech.api.capability.IEnergyContainer;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;

public class GTEnergyHandlerProxy
implements IEnergyHandlerAsync {
    public static final int ENERGY_MULTIPLIER = 4;
    public static final long MAX_CAPACITY = 0x1FFFFFFFFFFFFFFFL;
    private final IEnergyContainer energyContainer;

    public GTEnergyHandlerProxy(IEnergyContainer energyContainer) {
        this.energyContainer = energyContainer;
    }

    @Override
    public long getCurrentEnergy() {
        if (0x1FFFFFFFFFFFFFFFL <= this.energyContainer.getEnergyStored()) {
            return Long.MAX_VALUE;
        }
        return this.energyContainer.getEnergyStored() * 4L;
    }

    @Override
    public void setCurrentEnergy(long energy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxEnergy() {
        if (0x1FFFFFFFFFFFFFFFL <= this.energyContainer.getEnergyCapacity()) {
            return Long.MAX_VALUE;
        }
        return this.energyContainer.getEnergyCapacity() * 4L;
    }

    @Override
    public boolean extractEnergy(long energy) {
        long convertedEnergy = energy / 4L;
        long removed = -this.energyContainer.removeEnergy(convertedEnergy);
        if (removed < convertedEnergy) {
            this.energyContainer.addEnergy(removed);
            return false;
        }
        return true;
    }

    @Override
    public boolean receiveEnergy(long energy) {
        long convertedEnergy = energy / 4L;
        long added = this.energyContainer.addEnergy(convertedEnergy);
        if (added < energy) {
            this.energyContainer.removeEnergy(added);
            return false;
        }
        return true;
    }
}

