/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.handler;

import github.kasuminova.mmce.client.util.BufferBuilderPool;
import hellfirepvp.modularmachinery.common.item.ItemBlockController;
import hellfirepvp.modularmachinery.common.lib.ItemsMM;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMEItemBusAndPatternProviderItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item != ItemsMM.meItemInputBus && item != ItemsMM.meItemOutputBus && item != ItemsMM.mePatternProvider) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b("inventory")) {
                event.getToolTip().add(I18n.func_135052_a((String)"gui.meitembus.nbt_stored", (Object[])new Object[0]));
            } else if (tag.func_74764_b("patternProvider")) {
                event.getToolTip().add(I18n.func_135052_a((String)"gui.mepatternprovider.nbt_stored", (Object[])new Object[0]));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBlockControllerItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlockController)) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("owner")) {
            String ownerUUIDStr = tag.func_74779_i("owner");
            try {
                UUID ownerUUID = UUID.fromString(ownerUUIDStr);
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                UUID playerUUID = player.func_146103_bH().getId();
                if (playerUUID.equals(ownerUUID)) {
                    event.getToolTip().add(I18n.func_135052_a((String)"tooltip.item.controller.owner.self", (Object[])new Object[0]));
                } else {
                    event.getToolTip().add(I18n.func_135052_a((String)"tooltip.item.controller.owner.not_self", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                event.getToolTip().add(TextFormatting.RED + "NBT read error.");
            }
        }
    }

    @SubscribeEvent
    public void onDebugText(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        ArrayList left = event.getLeft();
        left.add("");
        left.add(String.format("%s[ModularMachinery - CE] %sBuffer Pool Size: %s%d InPool %s/ %s%d Total", TextFormatting.BLUE, TextFormatting.RESET, TextFormatting.GREEN, BufferBuilderPool.getPoolSize(), TextFormatting.RESET, TextFormatting.YELLOW, BufferBuilderPool.getCreatedBuffers()));
        left.add(String.format("%s[ModularMachinery - CE] %sBuffer Mem Usage: %s%s", TextFormatting.BLUE, TextFormatting.RESET, TextFormatting.YELLOW, ClientHandler.convertBytes(BufferBuilderPool.getBufferMemUsage())));
    }

    public static String convertBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " bytes";
        }
        if (bytes < 0x100000L) {
            double kb = (double)bytes / 1024.0;
            return String.format("%.2f KB", kb);
        }
        if (bytes < 0x40000000L) {
            double mb = (double)bytes / 1048576.0;
            return String.format("%.2f MB", mb);
        }
        double gb = (double)bytes / 1.073741824E9;
        return String.format("%.2f GB", gb);
    }
}

