/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.event.machine;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.handler.UpgradeMachineEventHandler;
import github.kasuminova.mmce.common.helper.IMachineController;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTileNotifiable;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.eventhandler.Event;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.modularmachinery.MachineEvent")
public class MachineEvent
extends Event {
    protected final TileMultiblockMachineController controller;

    public MachineEvent(TileMultiblockMachineController controller) {
        this.controller = controller;
    }

    @ZenGetter(value="controller")
    public IMachineController getIMachineController() {
        return this.controller;
    }

    public TileMultiblockMachineController getController() {
        return this.controller;
    }

    public void postEvent() {
        try {
            this.postEventToComponents();
            UpgradeMachineEventHandler.onMachineEvent(this);
            if (!this.isCanceled()) {
                this.postCrTEvent();
            }
        }
        catch (Exception e) {
            ModularMachinery.log.warn("Caught an exception when post event!", (Throwable)e);
        }
    }

    public void postEventToComponents() {
        for (TileEntity tileEntity : this.controller.getFoundComponents().keySet()) {
            if (!(tileEntity instanceof MachineComponentTileNotifiable)) continue;
            MachineComponentTileNotifiable componentTile = (MachineComponentTileNotifiable)tileEntity;
            componentTile.onMachineEvent(this);
            if (!this.isCanceled()) continue;
            break;
        }
    }

    public void postCrTEvent() {
        DynamicMachine foundMachine = this.controller.getFoundMachine();
        if (foundMachine == null) {
            return;
        }
        List<IEventHandler<MachineEvent>> handlers = foundMachine.getMachineEventHandlers(((Object)((Object)this)).getClass());
        if (handlers == null) {
            return;
        }
        for (IEventHandler<MachineEvent> handler : handlers) {
            handler.handle((Object)this);
            if (!this.isCanceled()) continue;
            break;
        }
    }

    @ZenSetter(value="canceled")
    public void setCanceled(boolean cancel) {
        super.setCanceled(cancel);
    }

    public boolean isCancelable() {
        return true;
    }
}

