/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.SlotRestrictedInput;
import appeng.util.Platform;
import com.mekeng.github.common.container.sync.IGasSyncContainer;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.util.helpers.GasSyncHelper;
import github.kasuminova.mmce.common.tile.base.MEGasBus;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.items.IItemHandler;

public abstract class ContainerMEGasBus
extends ContainerUpgradeable
implements IGasSyncContainer {
    protected final GasSyncHelper tankSync;
    private final MEGasBus owner;
    @GuiSync(value=7)
    public int capacityUpgrades = 0;

    public ContainerMEGasBus(InventoryPlayer ip, MEGasBus te) {
        super(ip, (IUpgradeableHost)te);
        this.owner = te;
        this.tankSync = GasSyncHelper.create((IGasInventory)this.owner.getTanks(), (int)0);
    }

    public void receiveGasSlots(Map<Integer, IAEGasStack> map) {
        this.tankSync.readPacket(map);
    }

    protected void setupConfig() {
        this.setupUpgrades();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    protected void setupUpgrades() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        for (int i = 0; i < this.availableUpgrades(); ++i) {
            this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.UPGRADES, upgrades, i, 187, 8 + 18 * i, this.getInventoryPlayer()).setNotDraggable());
        }
    }

    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.tankSync.sendDiff((Iterable)this.field_75149_d);
            int installedUpgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            if (this.capacityUpgrades != installedUpgrades) {
                this.capacityUpgrades = installedUpgrades;
            }
        }
        super.func_75142_b();
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (Platform.isClient() && field.equals("capacityUpgrades")) {
            this.capacityUpgrades = (Integer)newValue;
            this.owner.getTanks().setCap((int)(Math.pow(4.0, this.capacityUpgrades + 1) * 2000.0));
        }
    }

    protected boolean supportCapacity() {
        return false;
    }

    public int availableUpgrades() {
        return 5;
    }

    public boolean hasToolbox() {
        return false;
    }
}

