/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.common.capability;

import github.kasuminova.mmce.common.upgrade.DynamicMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.MachineUpgrade;
import github.kasuminova.mmce.common.upgrade.registry.RegistryUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityUpgrade {
    public static final ResourceLocation CAPABILITY_NAME = new ResourceLocation("modularmachinery", "upgrade_cap");
    @CapabilityInject(value=CapabilityUpgrade.class)
    public static Capability<CapabilityUpgrade> MACHINE_UPGRADE_CAPABILITY = null;
    private static final NBTTagCompound EMPTY_TAG_COMPOUND = new NBTTagCompound();
    private final List<MachineUpgrade> upgrades = new ArrayList<MachineUpgrade>();

    public static void register() {
        CapabilityManager.INSTANCE.register(CapabilityUpgrade.class, (Capability.IStorage)new Capability.IStorage<CapabilityUpgrade>(){

            @Nullable
            public NBTBase writeNBT(Capability<CapabilityUpgrade> capability, CapabilityUpgrade instance, EnumFacing side) {
                throw new UnsupportedOperationException("Deprecated");
            }

            public void readNBT(Capability<CapabilityUpgrade> capability, CapabilityUpgrade instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException("Deprecated");
            }
        }, CapabilityUpgrade::new);
    }

    public List<MachineUpgrade> getUpgrades() {
        return this.upgrades;
    }

    public void readNBT(NBTTagCompound tag) {
        this.upgrades.clear();
        for (String upgradeType : tag.func_150296_c()) {
            MachineUpgrade upgrade = RegistryUpgrade.getUpgrade(upgradeType);
            if (upgrade == null) continue;
            upgrade = upgrade.copy(ItemStack.field_190927_a);
            this.upgrades.add(upgrade);
            if (!(upgrade instanceof DynamicMachineUpgrade)) continue;
            NBTTagCompound upgradeTag = tag.func_74775_l(upgradeType);
            ((DynamicMachineUpgrade)upgrade).readItemNBT(upgradeTag);
        }
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (MachineUpgrade upgrade : this.upgrades) {
            if (upgrade instanceof DynamicMachineUpgrade) {
                tag.func_74782_a(upgrade.getType().getName(), (NBTBase)((DynamicMachineUpgrade)upgrade).writeItemNBT());
                continue;
            }
            tag.func_74782_a(upgrade.getType().getName(), (NBTBase)EMPTY_TAG_COMPOUND);
        }
        return tag;
    }
}

