/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.client.renderer.BufferBuilder;

public class BufferBuilderPool {
    private static final List<WeakReference<BufferBuilder>> BUFFERS = ObjectLists.synchronize((ObjectList)new ObjectArrayList());
    private static final NavigableMap<Integer, Queue<BufferBuilder>> POOL = new ConcurrentSkipListMap<Integer, Queue<BufferBuilder>>();

    public static synchronized BufferBuilder borrowBuffer(int initSize) {
        BufferBuilder buffer;
        Queue<BufferBuilder> ceiling;
        Map.Entry<Integer, Queue<BufferBuilder>> entry = POOL.ceilingEntry(initSize);
        Queue<BufferBuilder> queue = ceiling = entry == null ? null : entry.getValue();
        if (ceiling != null) {
            buffer = ceiling.poll();
            if (ceiling.isEmpty()) {
                POOL.remove(entry.getKey());
            }
            if (buffer != null) {
                return buffer;
            }
        }
        buffer = new BufferBuilder(initSize / 4);
        BUFFERS.add(new WeakReference<BufferBuilder>(buffer));
        return buffer;
    }

    public static synchronized void returnBuffer(BufferBuilder buffer) {
        buffer.func_178966_f().clear();
        buffer.func_178965_a();
        Queue builder = (Queue)POOL.get(buffer.func_178966_f().capacity());
        if (builder == null) {
            builder = POOL.computeIfAbsent(buffer.func_178966_f().capacity(), k -> new ConcurrentLinkedQueue());
            builder.offer(buffer);
            return;
        }
        builder.offer(buffer);
    }

    public static int getPoolSize() {
        return POOL.values().stream().mapToInt(Collection::size).sum();
    }

    public static int getCreatedBuffers() {
        return BUFFERS.size();
    }

    public static long getBufferMemUsage() {
        long sum = 0L;
        Iterator<WeakReference<BufferBuilder>> iterator = BUFFERS.iterator();
        while (iterator.hasNext()) {
            WeakReference<BufferBuilder> ref = iterator.next();
            BufferBuilder buffer = (BufferBuilder)ref.get();
            if (buffer == null) {
                iterator.remove();
                continue;
            }
            sum += (long)buffer.func_178966_f().capacity();
        }
        return sum;
    }
}

