/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.renderer;

import github.kasuminova.mmce.client.renderer.BloomGeoModelRenderer;
import github.kasuminova.mmce.client.renderer.GeoModelRenderTask;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import github.kasuminova.mmce.client.renderer.RenderType;
import github.kasuminova.mmce.client.util.ReusableVBOUploader;
import github.kasuminova.mmce.common.util.concurrent.Action;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;

public class ControllerModelRenderManager {
    public static final ControllerModelRenderManager INSTANCE = new ControllerModelRenderManager();
    private static final ReusableVBOUploader VBO_UPLOADER = new ReusableVBOUploader();
    private final Map<RenderType, Map<ResourceLocation, Int2ObjectMap<List<BufferBuilder>>>> buffers = new EnumMap<RenderType, Map<ResourceLocation, Int2ObjectMap<List<BufferBuilder>>>>(RenderType.class);
    private final Map<Object, Action> reinitializeCallback = new Reference2ObjectOpenHashMap();
    private final Set<TileMultiblockMachineController> toRender = new ReferenceOpenHashSet();
    private final Set<TileMultiblockMachineController> alive = new ReferenceOpenHashSet();

    public void addBuffer(int light, RenderType type, ResourceLocation textureGroup, BufferBuilder buffer) {
        ((List)this.buffers.computeIfAbsent(type, t -> new Object2ObjectOpenHashMap()).computeIfAbsent(textureGroup, t -> new Int2ObjectOpenHashMap()).computeIfAbsent((Object)light, t -> new ObjectArrayList())).add(buffer);
    }

    public void addReinitializeCallback(Object key, Action action) {
        this.reinitializeCallback.put(key, action);
    }

    public void reinitialize() {
        this.reinitializeCallback.values().forEach(Action::doAction);
        this.reinitializeCallback.clear();
    }

    public void addToRender(TileMultiblockMachineController ctrl) {
        this.toRender.add(ctrl);
        this.notifyAlive(ctrl);
    }

    public void notifyAlive(TileMultiblockMachineController ctrl) {
        this.alive.add(ctrl);
    }

    public void checkControllerState() {
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet(this.toRender);
        toRemove.removeAll(this.alive);
        for (TileMultiblockMachineController ctrl : toRemove) {
            GeoModelRenderTask removed = MachineControllerRenderer.INSTANCE.tasks.remove(ctrl);
            if (removed != null) {
                try {
                    removed.finalize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.toRender.remove(ctrl);
            if (!MachineControllerRenderer.shouldUseBloom()) continue;
            BloomGeoModelRenderer.INSTANCE.unregisterGlobal(ctrl);
        }
        this.alive.clear();
    }

    public void draw() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        this.buffers.forEach((type, textureGroups) -> {
            type.preDraw();
            textureGroups.forEach((textureLoc, lightBuffers) -> {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(textureLoc);
                lightBuffers.forEach((light, buffers) -> {
                    if (light != -1) {
                        int lx = light % 65536;
                        int ly = light / 65536;
                        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lx, (float)ly);
                        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                    }
                    VBO_UPLOADER.drawMultiple((List<BufferBuilder>)buffers);
                });
            });
            type.postDraw();
        });
        this.buffers.clear();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179121_F();
        this.reinitialize();
    }
}

