/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.renderer;

import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.client.renderer.ControllerModelRenderManager;
import github.kasuminova.mmce.client.renderer.GeoModelRenderTask;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.EffectRenderContext;
import gregtech.client.utils.IBloomEffect;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;

public class BloomGeoModelRenderer
implements IRenderSetup,
IBloomEffect {
    public static final BloomGeoModelRenderer INSTANCE = new BloomGeoModelRenderer();
    protected final Set<TileMultiblockMachineController> controllers = Collections.newSetFromMap(new ConcurrentHashMap());
    protected boolean initialized = false;
    protected boolean postProcessing = false;

    public void registerGlobal(TileMultiblockMachineController ctrl) {
        if (!this.initialized) {
            this.initialized = true;
            BloomEffectUtil.registerBloomRender((IRenderSetup)this, (BloomType)BloomType.UNREAL, (IBloomEffect)this, ticket -> true);
        }
        this.controllers.add(ctrl);
    }

    public void unregisterGlobal(TileMultiblockMachineController ctrl) {
        this.controllers.remove(ctrl);
    }

    public void preDraw(@Nonnull BufferBuilder bufferBuilder) {
    }

    public void postDraw(@Nonnull BufferBuilder bufferBuilder) {
    }

    public void renderBloomEffect(@Nonnull BufferBuilder bufferBuilder, @Nonnull EffectRenderContext ctx) {
        GlStateManager.func_179094_E();
        this.controllers.forEach(ctrl -> this.renderModel((TileMultiblockMachineController)ctrl, ctx));
        ControllerModelRenderManager.INSTANCE.draw();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179121_F();
        if (this.postProcessing) {
            ControllerModelRenderManager.INSTANCE.checkControllerState();
        }
        this.postProcessing = !this.postProcessing;
    }

    protected void renderModel(TileMultiblockMachineController ctrl, @Nonnull EffectRenderContext ctx) {
        MachineControllerModel currentModel = ctrl.getCurrentModel();
        if (currentModel == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(currentModel.getTextureLocation());
        GeoModelRenderTask task = MachineControllerRenderer.INSTANCE.getTask(ctrl);
        if (!task.isAvailable()) {
            return;
        }
        task.renderBloom(this.postProcessing);
    }

    public boolean shouldRenderBloomEffect(@Nonnull EffectRenderContext context) {
        return !this.controllers.isEmpty();
    }
}

