/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.model;

import github.kasuminova.mmce.client.model.MachineControllerModel;
import github.kasuminova.mmce.client.model.ModelBufferSize;
import github.kasuminova.mmce.client.model.StaticModelBones;
import github.kasuminova.mmce.client.resource.GeoModelExternalLoader;
import github.kasuminova.mmce.common.concurrent.TaskExecutor;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class ModelPool {
    public static final int POOL_LIMIT = TaskExecutor.CLIENT_THREAD_COUNT;
    private final MachineControllerModel original;
    private final Map<MachineControllerModel, GeoModel> renderInstMap = new ConcurrentHashMap<MachineControllerModel, GeoModel>();
    private final Queue<MachineControllerModel> renderInstPool = new ArrayBlockingQueue<MachineControllerModel>(POOL_LIMIT);
    private StaticModelBones staticModelBones = null;
    private ModelBufferSize modelBufferSize = null;

    public ModelPool(MachineControllerModel original) {
        this.original = original;
        this.renderInstPool.offer(original);
    }

    public MachineControllerModel getOriginal() {
        return this.original;
    }

    public StaticModelBones getStaticModelBones() {
        if (this.staticModelBones == null) {
            this.staticModelBones = StaticModelBones.compile(this.original.getModel(), GeoModelExternalLoader.INSTANCE.getAnimation(this.original.animationFileLocation));
        }
        return this.staticModelBones;
    }

    public ModelBufferSize getModelBufferSize() {
        if (this.modelBufferSize == null) {
            this.modelBufferSize = ModelBufferSize.calculate(this.original.getModel(), this.getStaticModelBones());
        }
        return this.modelBufferSize;
    }

    public GeoModel getModel(MachineControllerModel model) {
        if (model == this.original) {
            return GeoModelExternalLoader.INSTANCE.getModel(this.original.modelLocation);
        }
        return this.renderInstMap.get((Object)model);
    }

    public synchronized MachineControllerModel borrowRenderInst() {
        if (this.renderInstPool.isEmpty()) {
            GeoModel loaded = GeoModelExternalLoader.INSTANCE.load(this.original.modelLocation);
            if (loaded == null) {
                throw new NullPointerException("Model file not found: " + this.original.modelLocation);
            }
            MachineControllerModel renderInst = this.original.createRenderInstance();
            this.renderInstMap.put(renderInst, loaded);
            return renderInst;
        }
        return this.renderInstPool.poll();
    }

    public synchronized void returnRenderInst(MachineControllerModel model) {
        this.renderInstPool.offer(model);
    }

    public synchronized void reset() {
        this.renderInstPool.clear();
        this.renderInstMap.clear();
    }
}

