/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.model;

import github.kasuminova.mmce.client.model.StaticModelBones;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class ModelBufferSize {
    private static final int BYTES_PER_CUBE = MachineControllerRenderer.VERTEX_FORMAT.func_177338_f() * 24;
    private int bufferSize = BYTES_PER_CUBE;
    private int bloomBufferSize = BYTES_PER_CUBE;
    private int transparentBufferSize = BYTES_PER_CUBE;
    private int bloomTransparentBufferSize = BYTES_PER_CUBE;
    private int staticBufferSize = BYTES_PER_CUBE;
    private int staticBloomBufferSize = BYTES_PER_CUBE;
    private int staticTransparentBufferSize = BYTES_PER_CUBE;
    private int staticBloomTransparentBufferSize = BYTES_PER_CUBE;
    private final GeoModel model;
    private final StaticModelBones staticModelBones;

    public static ModelBufferSize calculate(GeoModel model, StaticModelBones staticModelBones) {
        return new ModelBufferSize(model, staticModelBones);
    }

    private ModelBufferSize(GeoModel model, StaticModelBones staticModelBones) {
        this.model = model;
        this.staticModelBones = staticModelBones;
        this.calculate();
    }

    private void calculate() {
        for (GeoBone bone : this.model.topLevelBones) {
            this.calculateRecursive(bone, false, false);
        }
    }

    public void calculateRecursive(GeoBone bone, boolean bloom, boolean transparent) {
        boolean isStatic = this.staticModelBones.isStaticBone(bone.name);
        if (bloom && transparent || ModelBufferSize.isBloom(bone) && ModelBufferSize.isTransparent(bone)) {
            bloom = true;
            transparent = true;
            if (isStatic) {
                this.staticBloomTransparentBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
            } else {
                this.bloomTransparentBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
            }
        } else if (bloom || ModelBufferSize.isBloom(bone)) {
            bloom = true;
            if (isStatic) {
                this.staticBloomBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
            } else {
                this.bloomBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
            }
        } else if (transparent || ModelBufferSize.isTransparent(bone)) {
            transparent = true;
            if (isStatic) {
                this.staticTransparentBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
            } else {
                this.transparentBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
            }
        } else if (isStatic) {
            this.staticBufferSize += BYTES_PER_CUBE * bone.childCubes.size();
        } else {
            this.bufferSize += BYTES_PER_CUBE * bone.childCubes.size();
        }
        if (!bone.childBones.isEmpty()) {
            for (GeoBone child : bone.childBones) {
                this.calculateRecursive(child, bloom, transparent);
            }
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBloomBufferSize() {
        return this.bloomBufferSize;
    }

    public int getTransparentBufferSize() {
        return this.transparentBufferSize;
    }

    public int getBloomTransparentBufferSize() {
        return this.bloomTransparentBufferSize;
    }

    public int getStaticBufferSize() {
        return this.staticBufferSize;
    }

    public int getStaticBloomBufferSize() {
        return this.staticBloomBufferSize;
    }

    public int getStaticTransparentBufferSize() {
        return this.staticTransparentBufferSize;
    }

    public int getStaticBloomTransparentBufferSize() {
        return this.staticBloomTransparentBufferSize;
    }

    private static boolean isBloom(GeoBone bone) {
        return bone.name.startsWith("emissive") || bone.name.startsWith("bloom");
    }

    private static boolean isTransparent(GeoBone bone) {
        return bone.name.startsWith("transparent") || bone.name.startsWith("emissive_transparent") || bone.name.startsWith("bloom_transparent");
    }
}

