/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.model;

import github.kasuminova.mmce.client.model.ModelBufferSize;
import github.kasuminova.mmce.client.model.ModelPool;
import github.kasuminova.mmce.client.model.StaticModelBones;
import github.kasuminova.mmce.client.resource.GeoModelExternalLoader;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;

public class MachineControllerModel
extends AnimatedGeoModel<TileMultiblockMachineController> {
    protected final String modelName;
    protected final ResourceLocation modelLocation;
    protected final ResourceLocation textureLocation;
    protected final ResourceLocation animationFileLocation;
    protected ModelPool pool = null;
    protected GeoModel currentModel = null;

    public MachineControllerModel(String modelName, ResourceLocation modelLocation, ResourceLocation textureLocation, ResourceLocation animationFileLocation) {
        this.modelName = modelName;
        this.modelLocation = modelLocation;
        this.textureLocation = textureLocation;
        this.animationFileLocation = animationFileLocation;
    }

    public MachineControllerModel getRenderInstance() {
        if (this.pool.getOriginal() != this) {
            throw new IllegalStateException("Cannot return render instance of a model that is not the render instance!");
        }
        return this.pool.borrowRenderInst();
    }

    public void returnRenderInst() {
        this.pool.returnRenderInst(this);
    }

    public void initializePool() {
        this.pool = new ModelPool(this);
    }

    public StaticModelBones getStaticModelBones() {
        return this.pool.getStaticModelBones();
    }

    public ModelBufferSize getBufferSize() {
        return this.pool.getModelBufferSize();
    }

    public MachineControllerModel createRenderInstance() {
        MachineControllerModel model = new MachineControllerModel(this.modelName, this.modelLocation, this.textureLocation, this.animationFileLocation);
        model.pool = this.pool;
        return model;
    }

    public GeoModel getModel() {
        return this.getModel(this.modelLocation);
    }

    public Animation getAnimation(String name, IAnimatable animatable) {
        return GeoModelExternalLoader.INSTANCE.getAnimation(this.animationFileLocation).getAnimation(name);
    }

    public GeoModel getModel(ResourceLocation location) {
        GeoModel model = this.pool.getModel(this);
        if (model != this.currentModel) {
            this.getAnimationProcessor().clearModelRendererList();
            for (GeoBone bone : model.topLevelBones) {
                this.registerBone(bone);
            }
            this.currentModel = model;
        }
        return model;
    }

    public String getModelName() {
        return this.modelName;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public ResourceLocation getAnimationFileLocation() {
        return this.animationFileLocation;
    }

    public ResourceLocation getModelLocation(TileMultiblockMachineController object) {
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation(TileMultiblockMachineController object) {
        return this.textureLocation;
    }

    public ResourceLocation getAnimationFileLocation(TileMultiblockMachineController animatable) {
        return this.animationFileLocation;
    }
}

