/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.model;

import github.kasuminova.mmce.client.model.MachineControllerModel;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DynamicMachineModelRegistry {
    public static final DynamicMachineModelRegistry INSTANCE = new DynamicMachineModelRegistry();
    private final Map<String, MachineControllerModel> machineModelRegistry = new HashMap<String, MachineControllerModel>();
    private final Map<DynamicMachine, MachineControllerModel> machineDefaultModel = new HashMap<DynamicMachine, MachineControllerModel>();

    private DynamicMachineModelRegistry() {
    }

    public void registerMachineModel(String modelName, MachineControllerModel model) {
        this.machineModelRegistry.put(modelName, model);
    }

    public MachineControllerModel getMachineModel(String modelName) {
        return this.machineModelRegistry.get(modelName);
    }

    public void registerMachineDefaultModel(DynamicMachine machine, MachineControllerModel model) {
        this.machineDefaultModel.put(machine, model);
    }

    public MachineControllerModel getMachineDefaultModel(DynamicMachine machine) {
        return this.machineDefaultModel.get(machine);
    }

    public Collection<MachineControllerModel> getAllModels() {
        return this.machineModelRegistry.values();
    }

    public void onReload() {
        this.machineDefaultModel.clear();
        this.machineModelRegistry.clear();
    }
}

