/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.slot;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtualJEI;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtualSelectable;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtualSelectableJEI;
import github.kasuminova.mmce.client.gui.widget.slot.SlotVirtual;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.integration.ingredient.IngredientItemStackRenderer;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public class SlotItemVirtual
extends SlotVirtual {
    protected ItemStack stackInSlot = ItemStack.field_190927_a;
    protected Function<ItemStack, List<String>> tooltipFunction = null;

    public SlotItemVirtual() {
    }

    public SlotItemVirtual(ItemStack stackInSlot) {
        this();
        this.stackInSlot = stackInSlot;
    }

    public static SlotItemVirtualSelectable ofSelectable() {
        return new SlotItemVirtualSelectable();
    }

    public static SlotItemVirtualSelectable ofSelectable(ItemStack stackInSlot) {
        return new SlotItemVirtualSelectable(stackInSlot);
    }

    public static SlotItemVirtualSelectable ofSelectableJEI() {
        return Mods.JEI.isPresent() ? new SlotItemVirtualSelectableJEI() : new SlotItemVirtualSelectable();
    }

    public static SlotItemVirtualSelectable ofSelectableJEI(ItemStack stackInSlot) {
        return Mods.JEI.isPresent() ? new SlotItemVirtualSelectableJEI(stackInSlot) : new SlotItemVirtualSelectable(stackInSlot);
    }

    public static SlotItemVirtual of() {
        return new SlotItemVirtual();
    }

    public static SlotItemVirtual of(ItemStack stackInSlot) {
        return new SlotItemVirtual(stackInSlot);
    }

    public static SlotItemVirtual ofJEI() {
        return Mods.JEI.isPresent() ? new SlotItemVirtualJEI() : new SlotItemVirtual();
    }

    public static SlotItemVirtual ofJEI(ItemStack stackInSlot) {
        return Mods.JEI.isPresent() ? new SlotItemVirtualJEI(stackInSlot) : new SlotItemVirtual(stackInSlot);
    }

    @Override
    public void preRender(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
    }

    @Override
    public void render(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        GuiScreen gui = widgetGui.getGui();
        Minecraft mc = gui.field_146297_k;
        int rx = renderPos.posX();
        int ry = renderPos.posY();
        this.slotTex.renderIfPresent(renderPos, renderSize, gui, tex -> {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        });
        if (this.stackInSlot.func_190926_b()) {
            return;
        }
        ++rx;
        ++ry;
        try {
            IngredientItemStackRenderer.DEFAULT_INSTANCE.render(mc, rx, ry, this.stackInSlot);
        }
        catch (Exception e) {
            ModularMachinery.log.warn("Failed to render virtual slot item!", (Throwable)e);
        }
        this.drawHoverOverlay(mousePos, rx, ry);
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void postRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (this.stackInSlot.func_190926_b() || !this.mouseOver) {
            return;
        }
        this.mouseOver = false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        if (this.stackInSlot.func_190926_b()) {
            return Collections.emptyList();
        }
        this.mouseOver = true;
        GuiScreen g = widgetGui.getGui();
        GuiUtils.preItemToolTip((ItemStack)this.stackInSlot);
        List toolTip = g.func_191927_a(this.stackInSlot);
        if (this.tooltipFunction != null) {
            toolTip.addAll((Collection)this.tooltipFunction.apply(this.stackInSlot));
        }
        if (this.stackInSlot.func_190916_E() >= 1000) {
            toolTip.add(MiscUtils.formatDecimal(this.stackInSlot.func_190916_E()));
        }
        return toolTip;
    }

    public ItemStack getStackInSlot() {
        return this.stackInSlot;
    }

    public SlotItemVirtual setStackInSlot(ItemStack stackInSlot) {
        this.stackInSlot = stackInSlot;
        return this;
    }

    public SlotItemVirtual setTooltipFunction(Function<ItemStack, List<String>> tooltipFunction) {
        this.tooltipFunction = tooltipFunction;
        return this;
    }

    public Function<ItemStack, List<String>> getTooltipFunction() {
        return this.tooltipFunction;
    }
}

