/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.slot;

import appeng.api.AEApi;
import com.mekeng.github.client.render.GasStackSizeRenderer;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.slot.SlotGasVirtualJEI;
import github.kasuminova.mmce.client.gui.widget.slot.SlotVirtual;
import hellfirepvp.modularmachinery.common.base.Mods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class SlotGasVirtual
extends SlotVirtual {
    protected static final GasStackSizeRenderer SIZE_RENDERER = new GasStackSizeRenderer();
    protected GasStack gasStack = null;

    public SlotGasVirtual(GasStack gasStack) {
        this.gasStack = gasStack;
    }

    public SlotGasVirtual() {
    }

    public static SlotGasVirtual of() {
        return new SlotGasVirtual();
    }

    public static SlotGasVirtual of(GasStack gasStack) {
        return new SlotGasVirtual(gasStack);
    }

    public static SlotGasVirtual ofJEI(GasStack gasStack) {
        return Mods.JEI.isPresent() ? new SlotGasVirtualJEI(gasStack) : new SlotGasVirtual(gasStack);
    }

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        Minecraft mc = Minecraft.func_71410_x();
        int rx = renderPos.posX();
        int ry = renderPos.posY();
        this.slotTex.renderIfPresent(renderPos, renderSize, gui, tex -> {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        });
        if (this.gasStack != null && this.gasStack.amount > 0) {
            int fluidColor = this.gasStack.getGas().getTint();
            float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(fluidColor & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
            ResourceLocation rl = this.gasStack.getGas().getIcon();
            TextureAtlasSprite tas = mc.func_147117_R().getTextureExtry(rl.toString());
            if (tas == null) {
                tas = mc.func_147117_R().func_174944_f();
            }
            int width = this.getWidth() - 2;
            int height = this.getHeight() - 2;
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            gui.getGui().func_175175_a(++rx, ++ry, tas, width, height);
            IGasStorageChannel channel = (IGasStorageChannel)AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class);
            SIZE_RENDERER.renderStackSize(mc.field_71466_p, (IAEGasStack)channel.createStack((Object)this.gasStack), rx, ry);
            this.drawHoverOverlay(mousePos, rx, ry);
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void postRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (this.gasStack == null || !this.mouseOver) {
            return;
        }
        this.mouseOver = false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        if (this.gasStack == null) {
            return Collections.emptyList();
        }
        this.mouseOver = true;
        ArrayList<String> toolTips = new ArrayList<String>();
        toolTips.add(this.gasStack.getGas().getLocalizedName());
        toolTips.add(this.gasStack.amount + "mB");
        toolTips.add(I18n.func_135052_a((String)"tooltip.fluidhatch.gas", (Object[])new Object[0]));
        return toolTips;
    }
}

