/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.preview;

import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.impl.preview.IngredientListVertical;
import github.kasuminova.mmce.client.gui.widget.impl.preview.MachineStructurePreviewPanel;
import github.kasuminova.mmce.client.gui.widget.impl.preview.WorldSceneRendererWidget;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtual;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtualSelectable;
import github.kasuminova.mmce.client.util.UpgradeIngredient;
import github.kasuminova.mmce.common.util.BlockPos2ValueMap;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class UpgradeIngredientList
extends IngredientListVertical {
    protected static final Color OVERLAY_COLOR = new Color(0, 255, 127, 150);
    protected final WorldSceneRendererWidget renderer;
    protected final DynamicMachine machine;
    protected final Map<BlockPos, List<SlotItemVirtualSelectable>> posToUpgradeSlot = new BlockPos2ValueMap<List<SlotItemVirtualSelectable>>();

    public UpgradeIngredientList(WorldSceneRendererWidget renderer, DynamicMachine machine) {
        this.setWidthHeight(25, 114);
        this.renderer = renderer;
        this.machine = machine;
        this.listBgTexLocation = MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION_SECOND;
        this.listBgTexX = 0;
        this.listBgTexY = 0;
        this.listBgTexHeight = 114;
    }

    @Override
    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.scrollbar.setWidthHeight(6, 112);
        ArrayList<UpgradeIngredient> ingredients = new ArrayList<UpgradeIngredient>();
        this.machine.getModifiers().values().stream().flatMap(Collection::stream).map(replacement -> UpgradeIngredient.of(replacement.getDescriptiveStack(), replacement)).forEach(ingredients::add);
        this.machine.getMultiBlockModifiers().stream().map(replacement -> UpgradeIngredient.of(replacement.getDescriptiveStack(), replacement)).forEach(ingredients::add);
        this.setUpgradeStackList(ingredients);
    }

    public UpgradeIngredientList setUpgradeStackList(List<UpgradeIngredient> ingredients) {
        this.getWidgets().clear();
        for (UpgradeIngredient upgradeIngredient : ingredients) {
            SlotItemVirtualSelectable slot = SlotItemVirtual.ofSelectableJEI(upgradeIngredient.descStack());
            slot.setOnClickedListener(__ -> this.onSlotSelectedStateChanged(slot, upgradeIngredient));
            slot.setTooltipFunction(stack -> {
                ArrayList<String> tips = new ArrayList<String>(upgradeIngredient.replacement().getDescriptionLines());
                if (slot.isClicked()) {
                    tips.add(I18n.func_135052_a((String)"gui.preview.button.toggle_upgrade_display.item.disable_overlay.tip", (Object[])new Object[0]));
                } else {
                    tips.add(I18n.func_135052_a((String)"gui.preview.button.toggle_upgrade_display.item.enable_overlay.tip", (Object[])new Object[0]));
                }
                return tips;
            });
            for (BlockPos pos : upgradeIngredient.replacementPattern().keySet()) {
                this.posToUpgradeSlot.computeIfAbsent(pos, list -> new LinkedList()).add(slot);
            }
            this.addWidget(slot);
        }
        return this;
    }

    @Override
    public IngredientListVertical setStackList(List<ItemStack> list, List<FluidStack> fluidList) {
        throw new UnsupportedOperationException("UpgradeIngredientList does not support setStackList(List<ItemStack> list), please use setUpgradeStackList(List<UpgradeIngredient> ingredients)");
    }

    public void onSlotSelectedStateChanged(SlotItemVirtualSelectable slot, UpgradeIngredient ingredient) {
        if (slot.isClicked()) {
            this.renderer.addBlockOverlays(ingredient.replacementPattern().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> OVERLAY_COLOR, (a, b) -> b)));
            return;
        }
        block0: for (BlockPos pos : ingredient.replacementPattern().keySet()) {
            for (SlotItemVirtualSelectable anotherSlot : this.posToUpgradeSlot.get(pos)) {
                if (!anotherSlot.isClicked()) continue;
                continue block0;
            }
            this.renderer.removeBlockOverlay(pos);
        }
    }
}

