/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.preview;

import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.Button;
import github.kasuminova.mmce.client.gui.widget.Button4State;
import github.kasuminova.mmce.client.gui.widget.Button5State;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.impl.preview.IngredientList;
import github.kasuminova.mmce.client.gui.widget.impl.preview.IngredientListVertical;
import github.kasuminova.mmce.client.gui.widget.impl.preview.LayerRenderScrollbar;
import github.kasuminova.mmce.client.gui.widget.impl.preview.PreviewStatusBar;
import github.kasuminova.mmce.client.gui.widget.impl.preview.StructurePreviewTitle;
import github.kasuminova.mmce.client.gui.widget.impl.preview.UpgradeIngredientList;
import github.kasuminova.mmce.client.gui.widget.impl.preview.WorldSceneRendererWidget;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtual;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.client.util.DynamicMachineRenderContext;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.item.ItemBlockController;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MachineStructurePreviewPanel
extends Row {
    public static final ResourceLocation WIDGETS_TEX_LOCATION = new ResourceLocation("modularmachinery", "textures/gui/guiblueprint_new.png");
    public static final ResourceLocation WIDGETS_TEX_LOCATION_SECOND = new ResourceLocation("modularmachinery", "textures/gui/guiblueprint_new_second.png");
    public static final int PANEL_WIDTH = 184;
    public static final int PANEL_HEIGHT = 220;
    public static final int WORLD_RENDERER_WIDTH = 172;
    public static final int WORLD_RENDERER_HEIGHT = 150;
    protected final WorldSceneRendererWidget renderer;

    public MachineStructurePreviewPanel(DynamicMachine machine) {
        boolean hasModifier;
        this.renderer = (WorldSceneRendererWidget)new WorldSceneRendererWidget(machine).setWidthHeight(172, 150).setAbsXY(6, 26);
        StructurePreviewTitle title = new StructurePreviewTitle(machine);
        PreviewStatusBar previewStatusBar = new PreviewStatusBar(this.renderer);
        Button5State menuBtn = new Button5State();
        Button5State toggleLayerRender = new Button5State();
        Button4State placeWorldPreview = new Button4State();
        Button5State enableCycleReplaceableBlocks = new Button5State();
        Button4State dynamicPatternPlus = new Button4State();
        Button4State dynamicPatternSubtract = new Button4State();
        Button machineExtraInfo = new Button();
        Button5State toggleFormed = new Button5State();
        Button5State showUpgrades = new Button5State();
        Button4State resetCenter = new Button4State();
        IngredientList ingredientList = new IngredientList();
        SlotItemVirtual selectedBlockIngredientMain = SlotItemVirtual.ofJEI();
        IngredientListVertical selectedBlockIngredientList = new IngredientListVertical();
        LayerRenderScrollbar layerScrollbar = new LayerRenderScrollbar(this.renderer);
        UpgradeIngredientList upgradeIngredientList = new UpgradeIngredientList(this.renderer, machine);
        title.setAbsXY(5, 5);
        previewStatusBar.setMaxWidth(172).setAbsXY(6, 26);
        menuBtn.setClickedTexture(214, 15).setMouseDownTexture(214, 15).setHoveredTexture(199, 15).setTexture(184, 15).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.menu.tip", (Object[])new Object[0]))).setWidthHeight(13, 13);
        toggleLayerRender.setClickedTexture(229, 30).setMouseDownTexture(214, 30).setHoveredTexture(199, 30).setTexture(184, 30).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> toggleLayerRender.isClicked() ? Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.toggle_3d_render.tip", (Object[])new Object[0])) : Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.toggle_layer_render.tip", (Object[])new Object[0]))).setWidthHeight(13, 13);
        placeWorldPreview.setMouseDownTexture(214, 45).setHoveredTexture(199, 45).setTexture(184, 45).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.place_world_preview.tip", (Object[])new Object[0]))).setWidthHeight(13, 13);
        enableCycleReplaceableBlocks.setClickedTexture(214, 105).setMouseDownTexture(214, 105).setHoveredTexture(199, 105).setTexture(184, 105).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> enableCycleReplaceableBlocks.isClicked() ? Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.disable_cycle_replaceable_blocks.tip", (Object[])new Object[0])) : Arrays.asList(I18n.func_135052_a((String)"gui.preview.button.enable_cycle_replaceable_blocks.tip.0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.preview.button.enable_cycle_replaceable_blocks.tip.1", (Object[])new Object[0]))).setWidthHeight(13, 13);
        dynamicPatternPlus.setMouseDownTexture(214, 60).setHoveredTexture(199, 60).setTexture(184, 60).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.dynamic_pattern_plus.tip", (Object[])new Object[]{this.renderer.getDynamicPatternSize()}))).setWidthHeight(13, 13);
        dynamicPatternSubtract.setMouseDownTexture(214, 75).setHoveredTexture(199, 75).setTexture(184, 75).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.dynamic_pattern_subtract.tip", (Object[])new Object[]{this.renderer.getDynamicPatternSize()}))).setWidthHeight(13, 13);
        machineExtraInfo.setHoveredTexture(199, 214).setTexture(184, 214).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> this.getMachineExtraInfo(machine)).setWidthHeight(13, 13);
        toggleFormed.setClickedTexture(229, 0).setMouseDownTexture(214, 0).setHoveredTexture(199, 0).setTexture(184, 0).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> toggleFormed.isClicked() ? Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.toggle_unformed.tip", (Object[])new Object[0])) : Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.toggle_formed.tip", (Object[])new Object[0]))).setWidthHeight(13, 13);
        showUpgrades.setClickedTexture(214, 90).setMouseDownTexture(214, 90).setHoveredTexture(199, 90).setTexture(184, 90).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> showUpgrades.isClicked() ? Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.toggle_upgrade_display.disable.tip", (Object[])new Object[0])) : Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.toggle_upgrade_display.enable.tip", (Object[])new Object[0]))).setWidthHeight(13, 13);
        resetCenter.setMouseDownTexture(214, 229).setHoveredTexture(199, 229).setTexture(184, 229).setTextureLocation(WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> Collections.singletonList(I18n.func_135052_a((String)"gui.preview.button.reset_center.tip", (Object[])new Object[0]))).setWidthHeight(13, 13);
        ingredientList.setAbsXY(5, 179);
        selectedBlockIngredientMain.setSlotTex(TextureProperties.of(WIDGETS_TEX_LOCATION, 229, 105)).setAbsXY(8, 28);
        selectedBlockIngredientList.setAbsXY(8, 48);
        Row bottomMenu = new Row();
        if (!machine.getDynamicPatterns().isEmpty()) {
            bottomMenu.addWidgets(dynamicPatternPlus.setMarginRight(2), dynamicPatternSubtract.setMarginRight(2));
        }
        bottomMenu.addWidgets(placeWorldPreview.setMarginRight(2), enableCycleReplaceableBlocks.setClicked(true).setMarginRight(2), toggleLayerRender.setMarginRight(2), menuBtn.setClicked(true).setMarginRight(2));
        bottomMenu.setAbsXY(184 - (bottomMenu.getWidth() + 6), 161);
        Row rightTopMenu = new Row();
        boolean bl = hasModifier = !machine.getModifiers().isEmpty() || !machine.getMultiBlockModifiers().isEmpty();
        if (hasModifier) {
            rightTopMenu.addWidgets(showUpgrades.setClicked(true).setMarginRight(2));
        }
        rightTopMenu.addWidgets(resetCenter.setMarginRight(2), toggleFormed.setMarginRight(2), machineExtraInfo.setMarginRight(2));
        rightTopMenu.setAbsXY(184 - (rightTopMenu.getWidth() + 6), 28);
        Row rightMenu = (Row)new Row().addWidgets(upgradeIngredientList.setEnabled(hasModifier).setMarginRight(2), layerScrollbar.setDisabled(true).setMarginRight(2));
        rightMenu.setAbsXY(184 - (rightMenu.getWidth() + (hasModifier ? 0 : 6)), 44);
        this.addWidgets(title, previewStatusBar, ingredientList, selectedBlockIngredientMain.setDisabled(true), selectedBlockIngredientList.setDisabled(true), rightTopMenu, rightMenu, bottomMenu);
        this.addWidget(this.renderer);
        menuBtn.setOnClickedListener(btn -> MachineStructurePreviewPanel.handleMenuButton(menuBtn, bottomMenu));
        toggleLayerRender.setOnClickedListener(btn -> this.handleToggleLayerRenderButton(toggleLayerRender, layerScrollbar, rightMenu));
        placeWorldPreview.setOnClickedListener(btn -> this.handlePlaceWorldPreviewButton(machine));
        enableCycleReplaceableBlocks.setOnClickedListener(btn -> this.handleCycleReplaceableBlocksButton(enableCycleReplaceableBlocks));
        if (!machine.getDynamicPatterns().isEmpty()) {
            dynamicPatternPlus.setOnClickedListener(btn -> this.handleDynamicPatternPlusButton());
            dynamicPatternSubtract.setOnClickedListener(btn -> this.handleDynamicPatternSubtractButton());
        }
        resetCenter.setOnClickedListener(btn -> this.handleResetCenterButton());
        toggleFormed.setOnClickedListener(btn -> this.handleToggleFormedButton(toggleFormed));
        if (hasModifier) {
            showUpgrades.setOnClickedListener(btn -> MachineStructurePreviewPanel.handleShowUpgradesButton(upgradeIngredientList, showUpgrades, rightMenu));
        }
        layerScrollbar.setOnScrollChanged(this::handleLayerScrollbarChanged);
        this.renderer.setOnPatternUpdate(r -> this.handleRendererPatternUpdate(machine, (WorldSceneRendererWidget)r, ingredientList));
        this.renderer.setOnBlockSelected(worldPos -> this.handlePatternBlockSelected((BlockPos)worldPos, selectedBlockIngredientMain, selectedBlockIngredientList));
    }

    @Nonnull
    protected List<String> getMachineExtraInfo(DynamicMachine machine) {
        BlockPos min = this.renderer.getPattern().getMin();
        BlockPos max = this.renderer.getPattern().getMax();
        ArrayList<String> tips = new ArrayList<String>();
        tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info", (Object[])new Object[0]));
        tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.xyz.0", (Object[])new Object[0]));
        tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.xyz.1", (Object[])new Object[]{max.func_177958_n() - min.func_177958_n() + 1, max.func_177956_o() - min.func_177956_o() + 1, max.func_177952_p() - min.func_177952_p() + 1}));
        tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.controller_y_pos", (Object[])new Object[]{Math.abs(machine.getPattern().getMin().func_177956_o())}));
        if (machine.getInternalParallelism() > 0) {
            tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.internal_parallelism", (Object[])new Object[]{machine.getInternalParallelism()}));
        }
        if (machine.getMaxParallelism() != Config.maxMachineParallelism) {
            tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.max_parallelism", (Object[])new Object[]{machine.getMaxParallelism()}));
        }
        if (machine.isHasFactory()) {
            tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.max_threads", (Object[])new Object[]{machine.getMaxThreads()}));
        }
        if (!machine.getCoreThreadPreset().isEmpty()) {
            tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.core_threads", (Object[])new Object[]{machine.getCoreThreadPreset().size()}));
        }
        if (!machine.getDynamicPatterns().isEmpty()) {
            tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.dynamic_pattern", (Object[])new Object[0]));
        }
        if (machine.isRequiresBlueprint()) {
            tips.add(I18n.func_135052_a((String)"gui.preview.button.machine_info.requires_blueprint", (Object[])new Object[0]));
        }
        return tips;
    }

    protected void handlePatternBlockSelected(BlockPos worldPos, SlotItemVirtual selectedBlockIngredientMain, IngredientListVertical selectedBlockIngredientList) {
        BlockPos patternPos;
        BlockPos blockPos = patternPos = worldPos == null ? null : worldPos.func_177973_b((Vec3i)this.renderer.getRenderOffset());
        if (patternPos == null) {
            selectedBlockIngredientMain.setStackInSlot(ItemStack.field_190927_a);
            selectedBlockIngredientMain.setDisabled(true);
            selectedBlockIngredientList.setStackList(Collections.emptyList(), Collections.emptyList());
            selectedBlockIngredientList.setDisabled(true);
            return;
        }
        World world = this.renderer.getWorldRenderer().getWorld();
        IBlockState clickedBlock = world.func_180495_p(worldPos);
        BlockArray.BlockInformation clicked = this.renderer.getPattern().getPattern().get(patternPos);
        ItemStack clickedBlockStack = clickedBlock.func_177230_c().getPickBlock(clickedBlock, this.renderer.getWorldRenderer().getLastTraceResult(), world, worldPos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        List replaceable = clicked.getIngredientList(patternPos, world).stream().filter(replaceableStack -> !ItemUtils.matchStacks(clickedBlockStack, replaceableStack)).collect(Collectors.toList());
        selectedBlockIngredientMain.setStackInSlot(clickedBlockStack);
        selectedBlockIngredientMain.setEnabled(true);
        selectedBlockIngredientList.setStackList(replaceable, Collections.emptyList());
        selectedBlockIngredientList.setEnabled(!replaceable.isEmpty());
    }

    protected void handleRendererPatternUpdate(DynamicMachine machine, WorldSceneRendererWidget r, IngredientList ingredientList) {
        TileEntity ctrlTE;
        List<ItemStack> stackList = r.getPattern().getDescriptiveStackList(r.getTickSnap(), r.getWorldRenderer().getWorld(), r.getRenderOffset());
        ingredientList.setStackList(stackList.stream().sorted((left, right) -> {
            if (left.func_77973_b() instanceof ItemBlockController) {
                return -1;
            }
            if (right.func_77973_b() instanceof ItemBlockController) {
                return 1;
            }
            return Integer.compare(right.func_190916_E(), left.func_190916_E());
        }).collect(Collectors.toList()), Collections.emptyList());
        if (r.isStructureFormed() && (ctrlTE = r.getWorldRenderer().getWorld().func_175625_s(BlockPos.field_177992_a.func_177971_a((Vec3i)r.getRenderOffset()))) instanceof TileMultiblockMachineController) {
            TileMultiblockMachineController controller = (TileMultiblockMachineController)ctrlTE;
            controller.setFoundMachine(machine);
        }
    }

    protected void handleLayerScrollbarChanged(Integer renderLayer) {
        int minY = this.renderer.getPattern().getMin().func_177956_o();
        int maxY = this.renderer.getPattern().getMax().func_177956_o();
        this.renderer.setRenderLayer(maxY - renderLayer + minY);
    }

    protected void handleResetCenterButton() {
        this.renderer.resetCenter();
    }

    protected void handleToggleFormedButton(Button5State toggleFormed) {
        this.renderer.setStructureFormed(toggleFormed.isClicked());
    }

    protected static void handleShowUpgradesButton(UpgradeIngredientList upgradeIngredientList, Button5State showUpgrades, Row rightMenu) {
        upgradeIngredientList.setEnabled(showUpgrades.isClicked());
        rightMenu.setAbsXY(184 - (rightMenu.getWidth() + 6), 44);
    }

    protected void handleDynamicPatternSubtractButton() {
        this.renderer.setDynamicPatternSize(Math.max(this.renderer.getDynamicPatternSize() - 1, 0));
    }

    protected void handleDynamicPatternPlusButton() {
        this.renderer.setDynamicPatternSize(this.renderer.getDynamicPatternSize() + 1);
    }

    protected void handleCycleReplaceableBlocksButton(Button5State enableCycleReplaceableBlocks) {
        this.renderer.setCycleBlocks(enableCycleReplaceableBlocks.isClicked());
    }

    protected void handlePlaceWorldPreviewButton(DynamicMachine machine) {
        DynamicMachineRenderContext renderContext = DynamicMachineRenderContext.createContext(machine, this.renderer.getDynamicPatternSize());
        renderContext.setShiftSnap(this.renderer.getTickSnap());
        ClientProxy.renderHelper.startPreview(renderContext);
        Minecraft.func_71410_x().func_147108_a(null);
    }

    protected void handleToggleLayerRenderButton(Button5State toggleLayerRender, LayerRenderScrollbar layerScrollbar, Row rightMenu) {
        boolean layerRender = toggleLayerRender.isClicked();
        if (layerRender) {
            this.renderer.useLayerRender();
            int minY = this.renderer.getPattern().getMin().func_177956_o();
            int maxY = this.renderer.getPattern().getMax().func_177956_o();
            layerScrollbar.setEnabled(true);
            layerScrollbar.getScrollbar().setRange(minY, maxY);
            this.renderer.setRenderLayer(minY);
        } else {
            this.renderer.use3DRender();
            layerScrollbar.setDisabled(true);
        }
        rightMenu.setAbsXY(184 - (rightMenu.getWidth() + 6), 44);
    }

    protected static void handleMenuButton(Button5State menuBtn, Row bottomMenu) {
        boolean enable = menuBtn.isClicked();
        bottomMenu.getWidgets().stream().filter(widget -> widget != menuBtn).forEach(widget -> widget.setEnabled(enable));
        bottomMenu.setAbsXY(184 - (bottomMenu.getWidth() + 6), 161);
    }
}

