/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.preview;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.Button4State;
import github.kasuminova.mmce.client.gui.widget.Scrollbar;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.impl.preview.MachineStructurePreviewPanel;
import github.kasuminova.mmce.client.gui.widget.impl.preview.WorldSceneRendererWidget;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class LayerRenderScrollbar
extends Column {
    protected int scrollBgTexX = 244;
    protected int scrollBgTexY = 0;
    protected int scrollBgTexYOffset = 12;
    protected int scrollBgTexWidth = 9;
    protected int scrollBgTexHeight = 90;
    protected Consumer<Integer> onScrollChanged = null;
    protected final Scrollbar scrollbar = (Scrollbar)new Scrollbar().setMarginVertical(2);

    public LayerRenderScrollbar(WorldSceneRendererWidget renderer) {
        Button4State up = new Button4State();
        Button4State down = new Button4State();
        up.setMouseDownTexture(206, 121).setHoveredTexture(195, 121).setTexture(184, 121).setUnavailableTexture(217, 121).setTextureLocation(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> {
            int minY = renderer.getPattern().getMin().func_177956_o();
            int maxY = renderer.getPattern().getMax().func_177956_o();
            int renderLayer = this.scrollbar.getCurrentScroll();
            return Arrays.asList(I18n.func_135052_a((String)"gui.preview.button.layer_render_scrollbar.up.tip", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.preview.button.layer_render_scrollbar.state.tip", (Object[])new Object[]{maxY - renderLayer + minY, this.scrollbar.getMaxScroll()}));
        }).setWidthHeight(9, 9);
        down.setMouseDownTexture(206, 132).setHoveredTexture(195, 132).setTexture(184, 132).setUnavailableTexture(217, 132).setTextureLocation(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> {
            int minY = renderer.getPattern().getMin().func_177956_o();
            int maxY = renderer.getPattern().getMax().func_177956_o();
            int renderLayer = this.scrollbar.getCurrentScroll();
            return Arrays.asList(I18n.func_135052_a((String)"gui.preview.button.layer_render_scrollbar.down.tip", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.preview.button.layer_render_scrollbar.state.tip", (Object[])new Object[]{maxY - renderLayer + minY, this.scrollbar.getMaxScroll()}));
        }).setWidthHeight(9, 9);
        this.scrollbar.getScroll().setMouseDownTexture(202, 158).setHoveredTexture(193, 158).setTexture(184, 158).setUnavailableTexture(211, 158).setTextureLocation(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION).setTooltipFunction(btn -> {
            int minY = renderer.getPattern().getMin().func_177956_o();
            int maxY = renderer.getPattern().getMax().func_177956_o();
            int renderLayer = this.scrollbar.getCurrentScroll();
            return Arrays.asList(I18n.func_135052_a((String)"gui.preview.button.layer_render_scrollbar.tip", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.preview.button.layer_render_scrollbar.state.tip", (Object[])new Object[]{maxY - renderLayer + minY, this.scrollbar.getMaxScroll()}));
        }).setWidthHeight(7, 15);
        this.scrollbar.setWidthHeight(7, 88).setMarginHorizontal(1).setMarginVertical(4);
        up.setOnClickedListener(btn -> this.scrollbar.setCurrentScroll(this.scrollbar.getCurrentScroll() - 1));
        down.setOnClickedListener(btn -> this.scrollbar.setCurrentScroll(this.scrollbar.getCurrentScroll() + 1));
        this.scrollbar.setOnValueChanged(scroll -> {
            if (this.onScrollChanged != null) {
                this.onScrollChanged.accept(scroll.getCurrentScroll());
            }
            up.setAvailable(scroll.getCurrentScroll() > scroll.getMinScroll());
            down.setAvailable(scroll.getCurrentScroll() < scroll.getMaxScroll());
        });
        this.addWidgets(up, this.scrollbar, down);
    }

    @Override
    protected void renderInternal(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.drawScrollbarBg(widgetGui, renderPos);
        super.renderInternal(widgetGui, renderSize, renderPos, mousePos);
    }

    protected void drawScrollbarBg(WidgetGui widgetGui, RenderPos renderPos) {
        GuiScreen gui = widgetGui.getGui();
        gui.field_146297_k.func_110434_K().func_110577_a(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION);
        gui.func_73729_b(renderPos.posX(), renderPos.posY() + this.scrollBgTexYOffset, this.scrollBgTexX, this.scrollBgTexY, this.scrollBgTexWidth, this.scrollBgTexHeight);
    }

    public Consumer<Integer> getOnScrollChanged() {
        return this.onScrollChanged;
    }

    public LayerRenderScrollbar setOnScrollChanged(Consumer<Integer> onScrollChanged) {
        this.onScrollChanged = onScrollChanged;
        return this;
    }

    public Scrollbar getScrollbar() {
        return this.scrollbar;
    }
}

