/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.impl.preview;

import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.Scrollbar;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.container.ScrollingColumn;
import github.kasuminova.mmce.client.gui.widget.impl.preview.MachineStructurePreviewPanel;
import github.kasuminova.mmce.client.gui.widget.slot.SlotFluidVirtual;
import github.kasuminova.mmce.client.gui.widget.slot.SlotItemVirtual;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IngredientList
extends ScrollingColumn {
    public static final int MAX_STACK_PER_ROW = 9;
    protected int maxStackPerRow = 9;

    public IngredientList() {
        this.setWidthHeight(174, 36);
    }

    @Override
    public void update(WidgetGui gui) {
        super.update(gui);
        this.scrollbar.setScrollUnit(this.scrollbar.getRange() / 5);
    }

    @Override
    public void initWidget(WidgetGui gui) {
        super.initWidget(gui);
        this.scrollbar.setMargin(3, 1, 1, 1);
        this.scrollbar.setWidthHeight(8, 34);
        this.scrollbar.getScroll().setMouseDownTexture(204, 143).setHoveredTexture(194, 143).setTexture(184, 143).setUnavailableTexture(214, 143).setTextureLocation(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION).setWidthHeight(8, 13);
    }

    public Scrollbar getScrollbar() {
        return this.scrollbar;
    }

    public IngredientList setStackList(List<ItemStack> list, List<FluidStack> fluidList) {
        ItemStack stack;
        int i;
        this.getWidgets().clear();
        Row row = new Row();
        int stackPerRow = 0;
        int totalSize = list.size() + fluidList.size();
        for (i = 0; i < list.size(); ++i) {
            stack = list.get(i);
            row.addWidget(SlotItemVirtual.ofJEI(stack).setSlotTex(TextureProperties.of(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION, 184, 194)));
            if (++stackPerRow < this.maxStackPerRow || i + 1 >= totalSize) continue;
            this.addWidget(row.setUseScissor(false));
            row = new Row();
            stackPerRow = 0;
        }
        for (i = 0; i < fluidList.size(); ++i) {
            stack = fluidList.get(i);
            row.addWidget(SlotFluidVirtual.ofJEI((FluidStack)stack).setSlotTex(TextureProperties.of(MachineStructurePreviewPanel.WIDGETS_TEX_LOCATION, 184, 194)));
            if (++stackPerRow < this.maxStackPerRow || i + 1 >= totalSize) continue;
            this.addWidget(row.setUseScissor(false));
            row = new Row();
            stackPerRow = 0;
        }
        this.addWidget(row.setUseScissor(false));
        return this;
    }

    public int getMaxStackPerRow() {
        return this.maxStackPerRow;
    }

    public void setMaxStackPerRow(int maxStackPerRow) {
        this.maxStackPerRow = maxStackPerRow;
    }
}

