/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.container;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderFunction;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.WidgetContainer;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Row
extends WidgetContainer {
    protected final List<DynamicWidget> widgets = new ArrayList<DynamicWidget>();
    protected boolean upAligned = true;
    protected boolean downAligned = false;

    @Override
    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.doRender(gui, renderSize, renderPos, mousePos, DynamicWidget::preRender);
    }

    @Override
    protected void renderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.doRender(gui, renderSize, renderPos, mousePos, DynamicWidget::render);
    }

    @Override
    protected void postRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.doRender(gui, renderSize, renderPos, mousePos, DynamicWidget::postRender);
    }

    protected void doRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos, RenderFunction renderFunction) {
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            if (widget.isVisible()) {
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                renderFunction.doRender(widget, gui, new RenderSize(widget.getWidth(), widget.getHeight()).smaller(renderSize), absRenderPos, mousePos.relativeTo(widgetRenderPos));
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
    }

    @Override
    public List<DynamicWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public Row addWidget(DynamicWidget widget) {
        this.widgets.add(widget);
        return this;
    }

    @Override
    public Row removeWidget(DynamicWidget widget) {
        this.widgets.remove(widget);
        return this;
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            if (widget.isMouseOver(relativeMousePos)) {
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                if (widget.onMouseClick(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton)) {
                    return true;
                }
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return false;
    }

    @Override
    public void onMouseClickGlobal(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            widget.onMouseClickGlobal(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton);
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
    }

    @Override
    public boolean onMouseClickMove(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseClickMove(mousePos.relativeTo(widgetRenderPos), absRenderPos, mouseButton)) {
                return true;
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseReleased(mousePos.relativeTo(widgetRenderPos), absRenderPos)) {
                return true;
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return false;
    }

    @Override
    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseDWheel(mousePos.relativeTo(widgetRenderPos), absRenderPos, wheel)) {
                return true;
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled() || !widget.onKeyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        int x = 0;
        int height = this.getHeight();
        List<String> tooltips = null;
        for (DynamicWidget widget : this.widgets) {
            List<String> hoverTooltips;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            int offsetX = widgetRenderPos.posX();
            int offsetY = widgetRenderPos.posY();
            MousePos relativeMousePos = mousePos.relativeTo(widgetRenderPos);
            if (widget.isMouseOver(relativeMousePos) && !(hoverTooltips = widget.getHoverTooltips(widgetGui, relativeMousePos)).isEmpty()) {
                tooltips = hoverTooltips;
                break;
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return tooltips != null ? tooltips : Collections.emptyList();
    }

    @Override
    public boolean onGuiEvent(GuiEvent event) {
        for (DynamicWidget widget : this.widgets) {
            if (!widget.onGuiEvent(event)) continue;
            return true;
        }
        return false;
    }

    public RenderPos getWidgetRenderOffset(DynamicWidget widget, int height, int x) {
        int yOffset;
        int xOffset;
        if (widget.isUseAbsPos()) {
            xOffset = widget.getAbsX();
            yOffset = widget.getAbsY();
        } else if (this.isCenterAligned()) {
            xOffset = x + widget.getMarginLeft();
            yOffset = (height - (widget.getMarginUp() + widget.getHeight() + widget.getMarginDown())) / 2;
        } else if (this.upAligned) {
            xOffset = x + widget.getMarginLeft();
            yOffset = widget.getMarginUp();
        } else if (this.downAligned) {
            xOffset = x + widget.getMarginLeft();
            yOffset = height - (widget.getHeight() + widget.getMarginDown());
        } else {
            return null;
        }
        return new RenderPos(xOffset, yOffset);
    }

    @Override
    public int getWidth() {
        int width = 0;
        int absWidgetMaxWidth = 0;
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled()) continue;
            int widgetWidth = widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
            if (widget.isUseAbsPos()) {
                absWidgetMaxWidth = Math.max(widgetWidth + widget.getAbsX(), absWidgetMaxWidth);
                continue;
            }
            width += widgetWidth;
        }
        return Math.max(width, absWidgetMaxWidth);
    }

    @Override
    public DynamicWidget setWidth(int width) {
        return this;
    }

    @Override
    public int getHeight() {
        int maxY = 0;
        for (DynamicWidget widget : this.widgets) {
            if (widget.isDisabled()) continue;
            int height = 0;
            if (widget.isUseAbsPos()) {
                height += widget.getAbsY();
            }
            if ((height += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown()) <= maxY) continue;
            maxY = height;
        }
        return maxY;
    }

    @Override
    public DynamicWidget setHeight(int height) {
        return this;
    }

    @Override
    public DynamicWidget setWidthHeight(int width, int height) {
        return this;
    }

    public boolean isUpAligned() {
        return this.upAligned;
    }

    public Row setUpAligned(boolean upAligned) {
        this.downAligned = !upAligned;
        this.upAligned = upAligned;
        return this;
    }

    public boolean isDownAligned() {
        return this.downAligned;
    }

    public Row setDownAligned(boolean downAligned) {
        this.upAligned = !downAligned;
        this.downAligned = downAligned;
        return this;
    }

    public Row setCenterAligned(boolean centerAligned) {
        if (centerAligned) {
            this.upAligned = true;
            this.downAligned = true;
            return this;
        }
        this.upAligned = true;
        this.downAligned = false;
        return this;
    }

    public boolean isCenterAligned() {
        return this.upAligned && this.downAligned;
    }
}

