/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.base;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.WidgetContainer;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class WidgetController {
    public static final ThreadLocal<RenderPos> TRANSLATE_STATE = ThreadLocal.withInitial(() -> new RenderPos(0, 0));
    protected final WidgetGui gui;
    protected final List<DynamicWidget> widgets = new ArrayList<DynamicWidget>();
    protected List<String> tooltipCache = new ArrayList<String>();
    private boolean initialized = false;

    public WidgetController(WidgetGui gui) {
        this.gui = gui;
    }

    @Deprecated
    public void addWidgetContainer(WidgetContainer widgetContainer) {
        this.widgets.add(widgetContainer);
    }

    public void addWidget(DynamicWidget widget) {
        this.widgets.add(widget);
    }

    public void render(MousePos mousePos, boolean translatePos) {
        RenderSize renderSize;
        MousePos relativeMousePos;
        RenderPos relativeRenderPos;
        RenderPos renderPos;
        this.tooltipCache = this.getHoverTooltipsInternal(mousePos);
        WidgetGui gui = this.gui;
        int guiLeft = gui.getGuiLeft();
        int guiTop = gui.getGuiTop();
        RenderPos offset = new RenderPos(guiLeft, guiTop);
        GlStateManager.func_179094_E();
        if (translatePos) {
            GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
            TRANSLATE_STATE.set(TRANSLATE_STATE.get().add(offset));
        }
        for (DynamicWidget container : this.widgets) {
            renderPos = new RenderPos(guiLeft + container.getAbsX(), guiTop + container.getAbsY());
            relativeRenderPos = renderPos.subtract(offset);
            relativeMousePos = mousePos.relativeTo(renderPos);
            renderSize = new RenderSize(container.getWidth(), container.getHeight());
            container.preRender(gui, renderSize, relativeRenderPos, relativeMousePos);
        }
        for (DynamicWidget container : this.widgets) {
            renderPos = new RenderPos(guiLeft + container.getAbsX(), guiTop + container.getAbsY());
            relativeRenderPos = renderPos.subtract(offset);
            relativeMousePos = mousePos.relativeTo(renderPos);
            renderSize = new RenderSize(container.getWidth(), container.getHeight());
            container.render(gui, renderSize, relativeRenderPos, relativeMousePos);
        }
        if (translatePos) {
            TRANSLATE_STATE.set(TRANSLATE_STATE.get().subtract(offset));
        }
        GlStateManager.func_179121_F();
    }

    public void postRender(MousePos mousePos, boolean translatePos) {
        WidgetGui gui = this.gui;
        int guiLeft = gui.getGuiLeft();
        int guiTop = gui.getGuiTop();
        RenderPos offset = new RenderPos(guiLeft, guiTop);
        GlStateManager.func_179094_E();
        if (translatePos) {
            GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
            TRANSLATE_STATE.set(TRANSLATE_STATE.get().add(offset));
        }
        for (DynamicWidget container : this.widgets) {
            RenderPos renderPos = new RenderPos(guiLeft + container.getAbsX(), guiTop + container.getAbsY());
            RenderPos relativeRenderPos = renderPos.subtract(new RenderPos(guiLeft, guiTop));
            MousePos relativeMousePos = mousePos.relativeTo(renderPos);
            RenderSize renderSize = new RenderSize(container.getWidth(), container.getHeight());
            container.postRender(gui, renderSize, relativeRenderPos, relativeMousePos);
        }
        if (translatePos) {
            TRANSLATE_STATE.set(TRANSLATE_STATE.get().subtract(offset));
        }
        GlStateManager.func_179121_F();
    }

    public void renderTooltip(MousePos mousePos) {
        int guiLeft = this.gui.getGuiLeft();
        int guiTop = this.gui.getGuiTop();
        List<String> hoverTooltips = this.getHoverTooltips(mousePos);
        if (!hoverTooltips.isEmpty()) {
            MousePos relativeMousePos = mousePos.relativeTo(new RenderPos(guiLeft, guiTop));
            this.gui.getGui().func_146283_a(hoverTooltips, relativeMousePos.mouseX(), relativeMousePos.mouseY());
        }
    }

    public void init() {
        if (!this.initialized) {
            WidgetGui gui = this.gui;
            this.widgets.forEach(container -> container.initWidget(gui));
        }
        this.initialized = true;
    }

    public void update() {
        WidgetGui gui = this.gui;
        this.widgets.forEach(container -> container.update(gui));
    }

    public void onGUIClosed() {
        WidgetGui gui = this.gui;
        this.widgets.forEach(container -> container.onGUIClosed(gui));
    }

    public void postGuiEvent(GuiEvent event) {
        for (DynamicWidget container : this.widgets) {
            if (container.onGuiEvent(event)) break;
        }
    }

    public boolean onMouseClicked(MousePos mousePos, int mouseButton) {
        WidgetGui gui = this.gui;
        int x = gui.getGuiLeft();
        int y = gui.getGuiTop();
        boolean mouseClickEventCancelled = false;
        for (DynamicWidget container : this.widgets) {
            RenderPos renderPos = new RenderPos(x + container.getAbsX(), y + container.getAbsY());
            RenderPos relativeRenderPos = renderPos.subtract(new RenderPos(x, y));
            MousePos relativeMousePos = mousePos.relativeTo(renderPos);
            container.onMouseClickGlobal(relativeMousePos, relativeRenderPos, mouseButton);
            if (mouseClickEventCancelled || !container.isMouseOver(relativeMousePos) || !container.onMouseClick(relativeMousePos, relativeRenderPos, mouseButton)) continue;
            mouseClickEventCancelled = true;
        }
        return mouseClickEventCancelled;
    }

    public boolean onMouseClickMove(MousePos mousePos, int mouseButton) {
        WidgetGui gui = this.gui;
        int x = gui.getGuiLeft();
        int y = gui.getGuiTop();
        for (DynamicWidget container : this.widgets) {
            RenderPos renderPos = new RenderPos(x + container.getAbsX(), y + container.getAbsY());
            RenderPos relativeRenderPos = renderPos.subtract(new RenderPos(x, y));
            MousePos relativeMousePos = mousePos.relativeTo(renderPos);
            if (!container.onMouseClickMove(relativeMousePos, relativeRenderPos, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseReleased(MousePos mousePos) {
        WidgetGui gui = this.gui;
        int x = gui.getGuiLeft();
        int y = gui.getGuiTop();
        for (DynamicWidget container : this.widgets) {
            RenderPos renderPos = new RenderPos(x + container.getAbsX(), y + container.getAbsY());
            RenderPos relativeRenderPos = renderPos.subtract(new RenderPos(x, y));
            MousePos relativeMousePos = mousePos.relativeTo(renderPos);
            if (!container.onMouseReleased(relativeMousePos, relativeRenderPos)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseInput(MousePos mousePos) {
        int wheel = Mouse.getEventDWheel();
        if (wheel == 0) {
            return false;
        }
        WidgetGui gui = this.gui;
        int x = gui.getGuiLeft();
        int y = gui.getGuiTop();
        for (DynamicWidget container : this.widgets) {
            RenderPos renderPos = new RenderPos(x + container.getAbsX(), y + container.getAbsY());
            RenderPos relativeRenderPos = renderPos.subtract(new RenderPos(x, y));
            MousePos relativeMousePos = mousePos.relativeTo(renderPos);
            if (!container.onMouseDWheel(relativeMousePos, relativeRenderPos, wheel)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        for (DynamicWidget container : this.widgets) {
            if (!container.onKeyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public List<String> getHoverTooltips(MousePos mousePos) {
        return this.tooltipCache;
    }

    @Nonnull
    private List<String> getHoverTooltipsInternal(MousePos mousePos) {
        WidgetGui gui = this.gui;
        int x = gui.getGuiLeft();
        int y = gui.getGuiTop();
        List<String> tooltips = null;
        for (DynamicWidget container : this.widgets) {
            List<String> hoverTooltips;
            RenderPos renderPos;
            MousePos relativeMousePos;
            if (!container.isMouseOver(relativeMousePos = mousePos.relativeTo(renderPos = new RenderPos(x + container.getAbsX(), y + container.getAbsY()))) || (hoverTooltips = container.getHoverTooltips(this.gui, relativeMousePos)).isEmpty()) continue;
            tooltips = hoverTooltips;
            break;
        }
        return tooltips != null ? tooltips : Collections.emptyList();
    }

    public WidgetGui getGui() {
        return this.gui;
    }

    public List<DynamicWidget> getWidgets() {
        return this.widgets;
    }

    @Deprecated
    public List<WidgetContainer> getContainers() {
        return this.widgets.stream().filter(WidgetContainer.class::isInstance).map(WidgetContainer.class::cast).collect(Collectors.toList());
    }
}

