/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget.base;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import java.util.Collections;
import java.util.List;

public abstract class DynamicWidget {
    protected int width = 0;
    protected int height = 0;
    protected int absX;
    protected int absY;
    protected boolean useAbsPos = false;
    protected int marginLeft = 0;
    protected int marginRight = 0;
    protected int marginUp = 0;
    protected int marginDown = 0;
    protected boolean visible = true;
    protected boolean enabled = true;

    public void initWidget(WidgetGui gui) {
    }

    public void preRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
    }

    public abstract void render(WidgetGui var1, RenderSize var2, RenderPos var3, MousePos var4);

    public void postRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
    }

    public void update(WidgetGui gui) {
    }

    public void onGUIClosed(WidgetGui gui) {
    }

    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        return false;
    }

    public void onMouseClickGlobal(MousePos mousePos, RenderPos renderPos, int mouseButton) {
    }

    public boolean onMouseClickMove(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        return false;
    }

    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        return false;
    }

    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        return false;
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean onGuiEvent(GuiEvent event) {
        return false;
    }

    @Deprecated
    public List<String> getHoverTooltips(MousePos mousePos) {
        return Collections.emptyList();
    }

    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        return this.getHoverTooltips(mousePos);
    }

    public boolean isMouseOver(MousePos mousePos) {
        return this.isMouseOver(mousePos.mouseX(), mousePos.mouseY());
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOver(0, 0, mouseX, mouseY);
    }

    public boolean isMouseOver(int startX, int startY, int mouseX, int mouseY) {
        if (this.isInvisible()) {
            return false;
        }
        int endX = startX + this.getWidth();
        int endY = startY + this.getHeight();
        return mouseX >= startX && mouseX < endX && mouseY >= startY && mouseY < endY;
    }

    public int getWidth() {
        return this.width;
    }

    public DynamicWidget setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public DynamicWidget setHeight(int height) {
        this.height = height;
        return this;
    }

    public DynamicWidget setWidthHeight(int width, int height) {
        return this.setWidth(width).setHeight(height);
    }

    public int getAbsX() {
        return this.absX;
    }

    public DynamicWidget setAbsX(int absX) {
        this.useAbsPos = true;
        this.absX = absX;
        return this;
    }

    public int getAbsY() {
        return this.absY;
    }

    public DynamicWidget setAbsY(int absY) {
        this.useAbsPos = true;
        this.absY = absY;
        return this;
    }

    public DynamicWidget setAbsXY(int absX, int absY) {
        this.useAbsPos = true;
        return this.setAbsX(absX).setAbsY(absY);
    }

    public DynamicWidget setUseAbsPos(boolean useAbsPos) {
        this.useAbsPos = useAbsPos;
        return this;
    }

    public boolean isUseAbsPos() {
        return this.useAbsPos;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public DynamicWidget setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public DynamicWidget setMarginRight(int marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public int getMarginUp() {
        return this.marginUp;
    }

    public DynamicWidget setMarginUp(int marginUp) {
        this.marginUp = marginUp;
        return this;
    }

    public int getMarginDown() {
        return this.marginDown;
    }

    public DynamicWidget setMarginDown(int marginDown) {
        this.marginDown = marginDown;
        return this;
    }

    public DynamicWidget setMarginVertical(int marginVertical) {
        this.marginUp = marginVertical;
        this.marginDown = marginVertical;
        return this;
    }

    public DynamicWidget setMarginHorizontal(int marginHorizontal) {
        this.marginLeft = marginHorizontal;
        this.marginRight = marginHorizontal;
        return this;
    }

    public DynamicWidget setMargin(int margin) {
        this.marginLeft = margin;
        this.marginRight = margin;
        this.marginUp = margin;
        this.marginDown = margin;
        return this;
    }

    public DynamicWidget setMargin(int marginLeft, int marginRight, int marginUp, int marginDown) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginUp = marginUp;
        this.marginDown = marginDown;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public DynamicWidget setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isInvisible() {
        return !this.visible;
    }

    public DynamicWidget setInvisible(boolean invisible) {
        this.visible = !invisible;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DynamicWidget setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public DynamicWidget setDisabled(boolean disabled) {
        this.enabled = !disabled;
        return this;
    }
}

