/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.Button4State;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.List;
import java.util.function.Consumer;

public class Scrollbar
extends DynamicWidget {
    public static final int DEFAULT_SCROLL_WIDTH = 6;
    public static final int DEFAULT_SCROLL_HEIGHT = 27;
    public static final int DEFAULT_TEXTURE_X = 0;
    public static final int DEFAULT_TEXTURE_Y = 22;
    public static final int DEFAULT_TEXTURE_OFFSET_X = 6;
    public static final int DEFAULT_TEXTURE_OFFSET_Y = 0;
    public static final int DEFAULT_SCROLL_UNIT = 1;
    protected final Button4State scroll = new Button4State();
    protected int maxScroll = 0;
    protected int minScroll = 0;
    protected int currentScroll = 0;
    protected int scrollUnit = 1;
    protected boolean mouseDown = false;
    protected boolean mouseWheelCheckPos = true;
    protected Consumer<Scrollbar> onValueChanged = null;

    public Scrollbar() {
        this.width = this.scroll.getWidth();
        this.height = this.scroll.getHeight() * 2;
    }

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        int height = renderSize.isHeightLimited() ? renderSize.height() : this.height;
        int scrollHeight = this.scroll.getHeight();
        int scrollWidth = this.scroll.getWidth();
        if (this.getRange() == 0) {
            this.scroll.render(gui, new RenderSize(scrollWidth, scrollHeight), renderPos, mousePos);
        } else {
            int offsetY = (this.currentScroll - this.minScroll) * (height - scrollHeight) / this.getRange();
            this.scroll.render(gui, new RenderSize(scrollWidth, scrollHeight), renderPos.add(new RenderPos(0, offsetY)), mousePos.relativeTo(new RenderPos(0, offsetY)));
        }
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (this.getRange() == 0 || mouseButton != 0) {
            return false;
        }
        int scrollHeight = this.scroll.getHeight();
        int offsetY = this.getRange() == 0 ? 0 : (this.currentScroll - this.minScroll) * (this.height - scrollHeight) / this.getRange();
        RenderPos offset = new RenderPos(0, offsetY);
        MousePos scrollMousePos = mousePos.relativeTo(offset);
        if (this.scroll.isMouseOver(scrollMousePos) && this.scroll.onMouseClick(mousePos, renderPos.subtract(offset), mouseButton)) {
            this.mouseDown = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseClickMove(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (this.mouseDown) {
            this.handleMouseDragMove(mousePos);
        }
        return super.onMouseClickMove(mousePos, renderPos, mouseButton);
    }

    protected void handleMouseDragMove(MousePos mousePos) {
        float clickedPercent = Math.min(Math.max((float)mousePos.mouseY() / (float)this.height, 0.0f), 1.0f);
        int scroll = Math.round((float)this.getRange() * clickedPercent);
        this.setCurrentScroll(scroll + this.minScroll);
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        int scrollHeight = this.scroll.getHeight();
        int offsetY = this.getRange() == 0 ? 0 : (this.currentScroll - this.minScroll) * (this.height - scrollHeight) / this.getRange();
        RenderPos offset = new RenderPos(0, offsetY);
        MousePos scrollMousePos = mousePos.relativeTo(offset);
        this.scroll.onMouseReleased(mousePos, renderPos.subtract(offset));
        this.mouseDown = false;
        return false;
    }

    @Override
    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int dWheel) {
        if (this.mouseWheelCheckPos && !this.isMouseOver(mousePos)) {
            return false;
        }
        int wheel = Math.max(Math.min(-dWheel, 1), -1);
        this.setCurrentScroll(this.currentScroll + wheel * this.scrollUnit);
        return true;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        int scrollHeight = this.scroll.getHeight();
        int offsetY = this.getRange() == 0 ? 0 : (this.currentScroll - this.minScroll) * (this.height - scrollHeight) / this.getRange();
        RenderPos offset = new RenderPos(0, offsetY);
        MousePos scrollMousePos = mousePos.relativeTo(offset);
        if (this.scroll.isMouseOver(scrollMousePos)) {
            return this.scroll.getHoverTooltips(widgetGui, mousePos);
        }
        return super.getHoverTooltips(widgetGui, mousePos);
    }

    public Button4State getScroll() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return this.maxScroll;
    }

    public int getMinScroll() {
        return this.minScroll;
    }

    public int getCurrentScroll() {
        return this.currentScroll;
    }

    public Scrollbar setCurrentScroll(int currentScroll) {
        this.currentScroll = Math.max(Math.min(currentScroll, this.maxScroll), this.minScroll);
        if (this.onValueChanged != null) {
            this.onValueChanged.accept(this);
        }
        return this;
    }

    public int getRange() {
        return this.maxScroll - this.minScroll;
    }

    public Scrollbar setRange(int min, int max) {
        this.minScroll = min;
        this.maxScroll = max;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.scroll.setAvailable(this.getRange() != 0);
        this.setCurrentScroll(this.currentScroll);
        return this;
    }

    public int getScrollUnit() {
        return this.scrollUnit;
    }

    public Scrollbar setScrollUnit(int scrollUnit) {
        this.scrollUnit = Math.max(scrollUnit, 1);
        return this;
    }

    public Consumer<Scrollbar> getOnValueChanged() {
        return this.onValueChanged;
    }

    public Scrollbar setOnValueChanged(Consumer<Scrollbar> onValueChanged) {
        this.onValueChanged = onValueChanged;
        return this;
    }

    public boolean isMouseWheelCheckPos() {
        return this.mouseWheelCheckPos;
    }

    public Scrollbar setMouseWheelCheckPos(boolean mouseWheelCheckPos) {
        this.mouseWheelCheckPos = mouseWheelCheckPos;
        return this;
    }
}

