/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class MultiLineLabel
extends DynamicWidget {
    public static final int DEFAULT_FONT_HEIGHT = 10;
    protected List<String> contents;
    protected boolean leftAligned = true;
    protected boolean rightAligned = false;
    protected boolean verticalCentering = false;
    protected boolean autoRecalculateSize = true;
    protected boolean autoWrap = true;
    protected float scale = 1.0f;

    public MultiLineLabel(List<String> contents) {
        this.contents = contents;
        this.width = Math.round(this.getMaxStringWidth());
        this.height = Math.round(this.getTotalHeight());
        this.setMargin(2);
    }

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        List<String> toRender;
        float scale = this.scale;
        if (scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
        int maxWidth = renderSize.isWidthLimited() && this.autoWrap ? Math.round(Math.max((float)renderSize.width() / scale, 10.0f / scale)) : -1;
        int maxHeight = renderSize.isHeightLimited() ? Math.round((float)renderSize.height() / scale) : Math.round((float)this.height / scale);
        float totalHeight = this.getTotalHeight();
        float posX = (float)renderPos.posX() / scale;
        float posY = (float)renderPos.posY() / scale + (this.verticalCentering ? ((float)maxHeight - totalHeight) / 2.0f : 0.0f);
        FontRenderer fr = gui.getGui().field_146297_k.field_71466_p;
        if (maxWidth == -1) {
            toRender = this.contents;
        } else {
            toRender = new LinkedList<String>();
            for (String s : this.contents) {
                toRender.addAll(fr.func_78271_c(s, maxWidth));
            }
        }
        float offsetY = 0.0f;
        float fontHeight = 10.0f * scale;
        for (String s : toRender) {
            fr.func_175063_a(s, posX + this.getLineRenderOffset(s, fr), posY + offsetY, 0xFFFFFF);
            if (!((offsetY += fontHeight) > (float)maxHeight + fontHeight)) continue;
            break;
        }
        if (scale != 1.0f) {
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected float getLineRenderOffset(String s, FontRenderer fr) {
        if (this.leftAligned && !this.rightAligned) {
            return 0.0f;
        }
        int width = this.getWidth();
        float stringWidth = (float)fr.func_78256_a(s) * this.scale;
        if (this.leftAligned && this.rightAligned) {
            return ((float)width - stringWidth) / 2.0f;
        }
        if (this.rightAligned) {
            return (float)width - stringWidth;
        }
        return ((float)width - stringWidth) / 2.0f;
    }

    public float getMaxStringWidth() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float maxWidth = 0.0f;
        for (String content : this.contents) {
            float width = (float)fr.func_78256_a(content) * this.scale;
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public float getTotalHeight() {
        return this.getTotalHeight(this.contents);
    }

    public float getTotalHeight(List<String> contents) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float height = 0.0f;
        for (String content : contents) {
            List listed = fr.func_78271_c(content, Math.round((float)this.width / this.scale));
            height += 10.0f * this.scale * (float)listed.size();
        }
        return height * this.scale;
    }

    public float getScale() {
        return this.scale;
    }

    public MultiLineLabel setScale(float scale) {
        this.scale = scale;
        this.height = Math.round(this.getTotalHeight());
        return this;
    }

    @Override
    public MultiLineLabel setWidth(int width) {
        super.setWidth(width);
        this.height = Math.round(this.getTotalHeight());
        return this;
    }

    public List<String> getContents() {
        return this.contents;
    }

    public MultiLineLabel setContents(List<String> contents) {
        this.contents = contents;
        if (this.autoRecalculateSize) {
            this.width = Math.round(this.getMaxStringWidth());
            this.height = Math.round(this.getTotalHeight());
        }
        return this;
    }

    public boolean isLeftAligned() {
        return this.leftAligned;
    }

    public MultiLineLabel setLeftAligned(boolean leftAligned) {
        this.rightAligned = !leftAligned;
        this.leftAligned = leftAligned;
        return this;
    }

    public boolean isRightAligned() {
        return this.rightAligned;
    }

    public MultiLineLabel setRightAligned(boolean rightAligned) {
        this.leftAligned = !rightAligned;
        this.rightAligned = rightAligned;
        return this;
    }

    public boolean isCenterAligned() {
        return this.leftAligned && this.rightAligned;
    }

    public MultiLineLabel setCenterAligned(boolean centerAligned) {
        if (centerAligned) {
            this.leftAligned = true;
            this.rightAligned = true;
            return this;
        }
        this.leftAligned = true;
        this.rightAligned = false;
        return this;
    }

    public boolean isVerticalCentering() {
        return this.verticalCentering;
    }

    public MultiLineLabel setVerticalCentering(boolean verticalCentering) {
        this.verticalCentering = verticalCentering;
        return this;
    }

    public boolean isAutoRecalculateSize() {
        return this.autoRecalculateSize;
    }

    public MultiLineLabel setAutoRecalculateSize(boolean autoRecalculateSize) {
        this.autoRecalculateSize = autoRecalculateSize;
        return this;
    }

    public boolean isAutoWrap() {
        return this.autoWrap;
    }

    public MultiLineLabel setAutoWrap(boolean autoWrap) {
        this.autoWrap = autoWrap;
        return this;
    }
}

