/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.Button4State;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class ButtonElements<E>
extends Button4State {
    private final List<ElementInfo> elements = new ObjectArrayList();
    private int currentElementIndex = 0;

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        super.render(gui, renderSize, renderPos, mousePos);
        if (!this.isVisible()) {
            return;
        }
        ElementInfo current = this.getCurrentElement();
        if (current == null) {
            return;
        }
        current.texture().render(this.textureLocation, renderPos, renderSize, gui);
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        if (this.isVisible() && this.isMouseOver(mousePos) && this.mouseDown) {
            this.mouseDown = false;
            this.findNextElement();
            if (this.onClickedListener != null) {
                this.onClickedListener.accept(this);
            }
            return true;
        }
        this.mouseDown = false;
        return false;
    }

    public void findNextElement() {
        this.currentElementIndex = this.currentElementIndex + 1 >= this.elements.size() ? 0 : ++this.currentElementIndex;
    }

    public ElementInfo getCurrentElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        if (this.currentElementIndex >= this.elements.size()) {
            this.currentElementIndex = 0;
        }
        return this.elements.get(this.currentElementIndex);
    }

    public E getCurrentSelection() {
        ElementInfo current = this.getCurrentElement();
        return current == null ? null : (E)current.element();
    }

    public ButtonElements<E> addElement(E element, TextureProperties texture) {
        this.elements.add(new ElementInfo(element, texture));
        return this;
    }

    public ButtonElements<E> setCurrentSelection(E element) {
        this.currentElementIndex = IntStream.range(0, this.elements.size()).filter(i -> this.elements.get(i).element() == element).findFirst().orElse(this.currentElementIndex);
        return this;
    }

    public final class ElementInfo {
        private final E element;
        private final TextureProperties texture;

        public ElementInfo(E element, TextureProperties texture) {
            this.element = element;
            this.texture = texture;
        }

        public E element() {
            return this.element;
        }

        public TextureProperties texture() {
            return this.texture;
        }
    }
}

