/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.Button4State;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.Optional;

public class Button5State
extends Button4State {
    protected TextureProperties clickedTexture = TextureProperties.EMPTY;
    protected boolean clicked = false;

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isUnavailable()) {
            this.unavailableTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        if (this.clicked) {
            this.clickedTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        if (this.mouseDown) {
            this.mouseDownTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        if (this.isMouseOver(mousePos)) {
            this.hoveredTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        this.texture.render(this.textureLocation, renderPos, renderSize, gui);
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        if (this.isVisible() && this.isMouseOver(mousePos) && this.mouseDown) {
            this.mouseDown = false;
            boolean bl = this.clicked = !this.clicked;
            if (this.onClickedListener != null) {
                this.onClickedListener.accept(this);
            }
            return true;
        }
        this.mouseDown = false;
        return false;
    }

    public Button5State setClickedTexture(int clickedTextureX, int clickedTextureY) {
        return this.setClickedTexture(TextureProperties.of(clickedTextureX, clickedTextureY));
    }

    public TextureProperties getClickedTexture() {
        return this.clickedTexture;
    }

    public Button5State setClickedTexture(TextureProperties clickedTexture) {
        this.clickedTexture = Optional.ofNullable(clickedTexture).orElse(TextureProperties.EMPTY);
        return this;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public Button5State setClicked(boolean clicked) {
        this.clicked = clicked;
        return this;
    }
}

