/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.Button;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Button4State
extends Button {
    protected TextureProperties mouseDownTexture = TextureProperties.EMPTY;
    protected boolean mouseDown = false;

    @Override
    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isUnavailable()) {
            this.unavailableTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        if (this.mouseDown) {
            this.mouseDownTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        if (this.isMouseOver(mousePos)) {
            this.hoveredTexture.render(this.textureLocation, renderPos, renderSize, gui);
            return;
        }
        this.texture.render(this.textureLocation, renderPos, renderSize, gui);
    }

    @Override
    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (this.isVisible() && this.isAvailable() && mouseButton == 0) {
            this.mouseDown = true;
            return true;
        }
        return super.onMouseClick(mousePos, renderPos, mouseButton);
    }

    @Override
    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        if (this.isVisible() && this.isMouseOver(mousePos) && this.mouseDown) {
            this.mouseDown = false;
            if (this.onClickedListener != null) {
                this.onClickedListener.accept(this);
            }
            return true;
        }
        this.mouseDown = false;
        return false;
    }

    @Override
    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        if (this.mouseDown) {
            return Collections.emptyList();
        }
        return super.getHoverTooltips(widgetGui, mousePos);
    }

    public Button4State setMouseDownTexture(int mouseDownTextureX, int mouseDownTextureY) {
        return this.setMouseDownTexture(TextureProperties.of(mouseDownTextureX, mouseDownTextureY));
    }

    public TextureProperties getMouseDownTexture() {
        return this.mouseDownTexture;
    }

    public Button4State setMouseDownTexture(TextureProperties mouseDownTexture) {
        this.mouseDownTexture = Optional.ofNullable(mouseDownTexture).orElse(TextureProperties.EMPTY);
        return this;
    }

    public boolean isMouseDown() {
        return this.mouseDown;
    }
}

