/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.util;

public class AnimationValue {
    private static final double EPSILON = 1.0E-7;
    private final double px3;
    private final double px2;
    private final double px1;
    private final double py3;
    private final double py2;
    private final double py1;
    private final int animationTime;
    private long startTime;
    private boolean finished = false;
    private float solveCache = 0.0f;
    private double prevValue;
    private double targetValue;

    public static AnimationValue ofFinished(double value, int animationTime, double a, double b, double c, double d) {
        return AnimationValue.ofFinished(value, value, animationTime, a, b, c, d);
    }

    public static AnimationValue ofFinished(double value, double targetValue, int animationTime, double a, double b, double c, double d) {
        AnimationValue of = AnimationValue.of(value, targetValue, animationTime, a, b, c, d);
        of.finished = true;
        of.solveCache = (float)of.solve(1.0);
        return of;
    }

    public static AnimationValue of(double value, int animationTime, double a, double b, double c, double d) {
        return new AnimationValue(value, value, animationTime, a, b, c, d);
    }

    public static AnimationValue of(double value, double targetValue, int animationTime, double a, double b, double c, double d) {
        return new AnimationValue(value, targetValue, animationTime, a, b, c, d);
    }

    public AnimationValue(double value, double targetValue, int animationTime, double a, double b, double c, double d) {
        this.prevValue = value;
        this.targetValue = targetValue;
        this.animationTime = animationTime;
        this.px3 = 3.0 * a;
        this.px2 = 3.0 * (c - a) - this.px3;
        this.px1 = 1.0 - this.px3 - this.px2;
        this.py3 = 3.0 * b;
        this.py2 = 3.0 * (d - b) - this.py3;
        this.py1 = 1.0 - this.py3 - this.py2;
    }

    public double get() {
        return this.prevValue + (this.targetValue - this.prevValue) * (double)this.getAnimationPercent();
    }

    public AnimationValue set(double targetValue) {
        this.prevValue += (this.targetValue - this.prevValue) * (double)this.getAnimationPercent();
        this.targetValue = targetValue;
        this.reset();
        return this;
    }

    public AnimationValue setImmediate(double targetValue) {
        this.prevValue = targetValue;
        this.targetValue = targetValue;
        this.finished = true;
        this.solveCache = (float)this.solve(1.0);
        return this;
    }

    public double getPrevValue() {
        return this.prevValue;
    }

    public double getTargetValue() {
        return this.targetValue;
    }

    public double getX(double t) {
        return ((this.px1 * t + this.px2) * t + this.px3) * t;
    }

    public double getY(double t) {
        return ((this.py1 * t + this.py2) * t + this.py3) * t;
    }

    public double solve(double x) {
        if (x == 0.0 || x == 1.0) {
            return this.getY(x);
        }
        double t = x;
        for (int i = 0; i < 8; ++i) {
            double g = this.getX(t) - x;
            if (Math.abs(g) < 1.0E-7) {
                return this.getY(t);
            }
            double d = (3.0 * this.px1 * t + 2.0 * this.px2) * t + this.px3;
            if (Math.abs(d) < 1.0E-6) break;
            t -= g / d;
        }
        return this.getY(t);
    }

    public float getAnimationPercent() {
        if (this.finished) {
            return this.solveCache;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.startTime;
        float timePercent = Math.max(Math.min((float)elapsedTime / (float)this.animationTime, 1.0f), 0.0f);
        double result = this.solve(timePercent);
        if (timePercent >= 1.0f) {
            this.finished = true;
            this.solveCache = (float)result;
        }
        return (float)result;
    }

    public boolean isAnimFinished() {
        return this.finished;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.finished = false;
    }
}

