/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import github.kasuminova.lumenized.client.ShaderManager;
import github.kasuminova.lumenized.common.config.LumenizedConfig;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class DepthTextureUtil {
    public static int framebufferObject;
    public static int framebufferDepthTexture;
    private static boolean useDefaultFBO;
    private static boolean lastBind;
    private static int lastWidth;
    private static int lastHeight;

    private static boolean shouldRenderDepthTexture() {
        return lastBind && !ShaderManager.isOptifineShaderPackLoaded() && OpenGlHelper.func_148822_b() && LumenizedConfig.hookDepthTexture;
    }

    public static void onPreWorldRender(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null) {
            if (DepthTextureUtil.shouldRenderDepthTexture()) {
                if (useDefaultFBO && GL11.glGetError() != 0) {
                    useDefaultFBO = false;
                    if (framebufferDepthTexture != 0) {
                        DepthTextureUtil.disposeDepthTexture();
                        DepthTextureUtil.createDepthTexture();
                    }
                }
                if (framebufferDepthTexture == 0) {
                    DepthTextureUtil.createDepthTexture();
                } else if (lastWidth != mc.func_147110_a().field_147621_c || lastHeight != mc.func_147110_a().field_147618_d) {
                    DepthTextureUtil.disposeDepthTexture();
                    DepthTextureUtil.createDepthTexture();
                }
            } else {
                DepthTextureUtil.disposeDepthTexture();
            }
            lastBind = false;
        }
    }

    public static void renderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewer = mc.func_175606_aa();
        if (framebufferDepthTexture != 0 && mc.field_71441_e != null && viewer != null && !useDefaultFBO) {
            int lastFBO = GlStateManager.func_187397_v((int)36006);
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)framebufferObject);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179090_x();
            mc.field_71438_f.func_174977_a(BlockRenderLayer.SOLID, (double)event.getPartialTicks(), 0, viewer);
            mc.field_71438_f.func_174977_a(BlockRenderLayer.CUTOUT_MIPPED, (double)event.getPartialTicks(), 0, viewer);
            GlStateManager.func_179098_w();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)lastFBO);
        }
    }

    public static void createDepthTexture() {
        int lastFBO = GL11.glGetInteger((int)36006);
        Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
        boolean stencil = framebuffer.isStencilEnabled() && useDefaultFBO;
        framebufferObject = useDefaultFBO ? framebuffer.field_147616_f : OpenGlHelper.func_153165_e();
        framebufferDepthTexture = TextureUtil.func_110996_a();
        GlStateManager.func_179144_i((int)framebufferDepthTexture);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)34891, (int)6409);
        GlStateManager.func_187421_b((int)3553, (int)34893, (int)515);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)(stencil ? 35056 : 33190), (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (int)0, (int)(stencil ? 34041 : 6402), (int)(stencil ? 34042 : 5125), null);
        GlStateManager.func_179144_i((int)0);
        lastWidth = framebuffer.field_147622_a;
        lastHeight = framebuffer.field_147620_b;
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)framebufferObject);
        OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)(stencil ? 33306 : OpenGlHelper.field_153201_h), (int)3553, (int)framebufferDepthTexture, (int)0);
        if (BloomEffectUtil.getBloomFBO() != null && useDefaultFBO) {
            RenderUtil.hookDepthTexture(BloomEffectUtil.getBloomFBO(), framebufferDepthTexture);
        }
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)lastFBO);
    }

    public static void disposeDepthTexture() {
        if (framebufferDepthTexture != 0 || framebufferObject != 0) {
            if (useDefaultFBO) {
                Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
                Framebuffer bloomFBO = BloomEffectUtil.getBloomFBO();
                if (bloomFBO != null) {
                    RenderUtil.hookDepthBuffer(bloomFBO, framebuffer.field_147624_h);
                }
                RenderUtil.hookDepthBuffer(framebuffer, framebuffer.field_147624_h);
            } else {
                OpenGlHelper.func_153174_h((int)framebufferObject);
            }
            TextureUtil.func_147942_a((int)framebufferDepthTexture);
            framebufferObject = 0;
            framebufferDepthTexture = 0;
        }
    }

    public static void bindDepthTexture() {
        lastBind = true;
        if (useDefaultFBO && framebufferDepthTexture != 0) {
            Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
            RenderUtil.hookDepthBuffer(framebuffer, framebuffer.field_147624_h);
        }
        GlStateManager.func_179144_i((int)framebufferDepthTexture);
    }

    public static void unBindDepthTexture() {
        GlStateManager.func_179144_i((int)0);
        if (useDefaultFBO) {
            Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
            RenderUtil.hookDepthTexture(framebuffer, framebufferDepthTexture);
        }
    }

    public static boolean isUseDefaultFBO() {
        return useDefaultFBO;
    }

    public static boolean isLastBind() {
        return framebufferObject != 0;
    }

    static {
        useDefaultFBO = true;
    }
}

