/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.shader;

import codechicken.lib.render.shader.ShaderHelper;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import github.kasuminova.lumenized.Lumenized;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Shaders {
    public static Minecraft mc = Minecraft.func_71410_x();
    private static final Map<ShaderObject, ShaderProgram> FULL_IMAGE_PROGRAMS = new HashMap<ShaderObject, ShaderProgram>();
    public static ShaderObject IMAGE_V;
    public static ShaderObject IMAGE_F;
    public static ShaderObject SCANNING;
    public static ShaderObject BLOOM_COMBINE;
    public static ShaderObject BLUR;
    public static ShaderObject DOWN_SAMPLING;
    public static ShaderObject UP_SAMPLING;
    public static ShaderObject S_BLUR;
    public static ShaderObject COMPOSITE;

    public static void initShaders() {
        IMAGE_V = Shaders.initShader(IMAGE_V, ShaderObject.ShaderType.VERTEX, "image.vert");
        IMAGE_F = Shaders.initShader(IMAGE_F, ShaderObject.ShaderType.FRAGMENT, "image.frag");
        SCANNING = Shaders.initShader(SCANNING, ShaderObject.ShaderType.FRAGMENT, "scanning.frag");
        BLOOM_COMBINE = Shaders.initShader(BLOOM_COMBINE, ShaderObject.ShaderType.FRAGMENT, "bloom_combine.frag");
        BLUR = Shaders.initShader(BLUR, ShaderObject.ShaderType.FRAGMENT, "blur.frag");
        DOWN_SAMPLING = Shaders.initShader(DOWN_SAMPLING, ShaderObject.ShaderType.FRAGMENT, "down_sampling.frag");
        UP_SAMPLING = Shaders.initShader(UP_SAMPLING, ShaderObject.ShaderType.FRAGMENT, "up_sampling.frag");
        S_BLUR = Shaders.initShader(S_BLUR, ShaderObject.ShaderType.FRAGMENT, "seperable_blur.frag");
        COMPOSITE = Shaders.initShader(COMPOSITE, ShaderObject.ShaderType.FRAGMENT, "composite.frag");
        FULL_IMAGE_PROGRAMS.clear();
    }

    private static ShaderObject initShader(ShaderObject object, ShaderObject.ShaderType shaderType, String location) {
        Shaders.unloadShader(object);
        return Shaders.loadShader(shaderType, location);
    }

    public static ShaderObject loadShader(ShaderObject.ShaderType shaderType, String location) {
        try {
            return new ShaderObject(shaderType, ShaderHelper.readShader((InputStream)ShaderHelper.getStream((String)String.format("/assets/%s/shaders/%s", "gregtech", location)))).compileShader();
        }
        catch (Exception exception) {
            Lumenized.log.error("error while loading shader {}", (Object)location, (Object)exception);
            return null;
        }
    }

    public static void unloadShader(ShaderObject shaderObject) {
        if (shaderObject != null) {
            shaderObject.disposeObject();
        }
    }

    public static boolean allowedShader() {
        return OpenGlHelper.field_148824_g;
    }

    public static Framebuffer renderFullImageInFBO(Framebuffer fbo, ShaderObject frag, Consumer<ShaderProgram.UniformCache> uniformCache) {
        if (fbo == null || frag == null || !Shaders.allowedShader()) {
            return fbo;
        }
        fbo.func_147610_a(true);
        ShaderProgram program = FULL_IMAGE_PROGRAMS.get(frag);
        if (program == null) {
            program = new ShaderProgram();
            program.attachShader(IMAGE_V);
            program.attachShader(frag);
            FULL_IMAGE_PROGRAMS.put(frag, program);
        }
        program.useShader(cache -> {
            cache.glUniform2F("u_resolution", (float)fbo.field_147621_c, (float)fbo.field_147618_d);
            if (uniformCache != null) {
                uniformCache.accept(cache);
            }
        });
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-1.0, -1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, -1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        program.releaseShader();
        return fbo;
    }

    static {
        if (Shaders.allowedShader()) {
            Shaders.initShaders();
        }
    }
}

