/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.lumenized.mixin;

import github.kasuminova.lumenized.mixin.LumenizedEarlyMixinLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraftforge.fml.common.Loader;
import zone.rong.mixinbooter.ILateMixinLoader;

public class LumenizedLateMixinLoader
implements ILateMixinLoader {
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            LumenizedEarlyMixinLoader.LOG.warn("[STELLAR_CORE] Mixin config {} is not found in config map! It will never be loaded.", (Object)mixinConfig);
            return false;
        }
        return supplier.getAsBoolean();
    }

    private static boolean modLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID) {
        MIXIN_CONFIGS.put(mixinConfig, () -> LumenizedLateMixinLoader.modLoaded(modID));
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID, BooleanSupplier condition) {
        MIXIN_CONFIGS.put(mixinConfig, () -> LumenizedLateMixinLoader.modLoaded(modID) && condition.getAsBoolean());
    }

    private static void addModdedMixinCFG(String mixinConfig, String[] modIDs, BooleanSupplier condition) {
        MIXIN_CONFIGS.put(mixinConfig, () -> Arrays.stream(modIDs).allMatch(Loader::isModLoaded) && condition.getAsBoolean());
    }

    private static void addModdedMixinCFG(String mixinConfig, String modID, String ... modIDs) {
        MIXIN_CONFIGS.put(mixinConfig, () -> LumenizedLateMixinLoader.modLoaded(modID) && Arrays.stream(modIDs).allMatch(Loader::isModLoaded));
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    static {
        LumenizedLateMixinLoader.addModdedMixinCFG("mixins.lumenized_modularrouters.json", "modularrouters");
    }
}

