/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.lumenized.mixin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zone.rong.mixinbooter.IEarlyMixinLoader;

public class LumenizedEarlyMixinLoader
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static final Logger LOG = LogManager.getLogger((String)"STELLAR_CORE");
    public static final String LOG_PREFIX = "[STELLAR_CORE] ";
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();

    public List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            LOG.warn("[STELLAR_CORE] Mixin config {} is not found in config map! It will never be loaded.", (Object)mixinConfig);
            return false;
        }
        return supplier.getAsBoolean();
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    public String[] getASMTransformerClass() {
        return new String[]{"gregtech.asm.GregTechTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        LumenizedEarlyMixinLoader.addMixinCFG("mixins.lumenized.json");
    }
}

