/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.mixin.voidcell.condenser.shared;

import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileCondenser;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import co.neeve.nae2.common.interfaces.IExtendedTileCondenser;
import co.neeve.nae2.common.items.cells.vc.VoidCell;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TileCondenser.class}, remap=false)
public abstract class MixinTileCondenser
extends AEBaseInvTile
implements IExtendedTileCondenser {
    @Unique
    private final AppEngInternalInventory nae2$voidCell = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    @Shadow
    @Final
    private AppEngInternalInventory outputSlot;
    @Shadow
    @Final
    private AppEngInternalInventory storageSlot;

    @Shadow
    public abstract double getStorage();

    @Shadow
    public abstract double getStoredPower();

    @Shadow
    protected abstract void setStoredPower(double var1);

    @Shadow
    public abstract void addPower(double var1);

    @Override
    public IItemHandler getVoidCellInv() {
        return this.nae2$voidCell;
    }

    @Inject(method={"writeToNBT"}, at={@At(value="RETURN")}, remap=true)
    public void writeToNBT(NBTTagCompound data, CallbackInfoReturnable<NBTTagCompound> cir) {
        this.nae2$voidCell.writeToNBT(data, "voidCellInv");
    }

    @Inject(method={"readFromNBT"}, at={@At(value="RETURN")}, remap=true)
    public void readFromNBT(NBTTagCompound data, CallbackInfo ci) {
        this.nae2$voidCell.readFromNBT(data, "voidCellInv");
    }

    @Inject(method={"onChangeInventory"}, at={@At(value="HEAD")}, cancellable=true)
    private void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added, CallbackInfo ci) {
        if (inv == this.nae2$voidCell && removed.func_190926_b() && added.func_77973_b() instanceof VoidCell) {
            this.addPower(0.0);
            ci.cancel();
        }
    }

    @Inject(method={"onChangeInventory", "addPower"}, at={@At(value="INVOKE", target="Lappeng/tile/misc/TileCondenser;getRequiredPower()D"), @At(value="INVOKE", target="Lappeng/tile/misc/TileCondenser;addOutput(Lnet/minecraft/item/ItemStack;)V")})
    private void onChangeInventory(CallbackInfo ci) {
        ItemStack is = this.getVoidCellInv().getStackInSlot(0);
        if (!is.func_190926_b()) {
            this.refillFromVoidCell(is);
        }
    }

    @WrapOperation(method={"onChangeInventory", "addPower"}, at={@At(value="INVOKE", target="Lappeng/tile/misc/TileCondenser;addOutput(Lnet/minecraft/item/ItemStack;)V")})
    private void bandAidFix(TileCondenser instance, ItemStack is, Operation<Void> operation, @Local(name={"output"}) ItemStack output, @Share(value="bandaid") LocalBooleanRef bandAidRef) {
        if (is == output && !bandAidRef.get()) {
            bandAidRef.set(true);
        }
        operation.call(new Object[]{instance, bandAidRef.get() ? output.func_77946_l() : is});
    }

    @Unique
    private void refillFromVoidCell(ItemStack is) {
        double toAdd;
        VoidCell cell;
        double cellPower;
        Item item = is.func_77973_b();
        if (item instanceof VoidCell && (cellPower = (cell = (VoidCell)item).getCondenserPower(is)) != 0.0 && (toAdd = this.getStorage() - this.getStoredPower()) > 0.0) {
            double toBeAdded = Math.min(cellPower, toAdd);
            cell.setCondenserPower(is, cell.getCondenserPower(is) - toBeAdded);
            this.setStoredPower(this.getStoredPower() + toBeAdded);
            this.markForUpdate();
        }
    }
}

