/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.sync;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.exceptions.AppEngException;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.AEBaseGui;
import appeng.container.AEBaseContainer;
import appeng.core.sync.GuiHostType;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import co.neeve.nae2.common.containers.ContainerPatternMultiTool;
import co.neeve.nae2.common.containers.ContainerReconstructionChamber;
import co.neeve.nae2.common.interfaces.INAEGuiItem;
import co.neeve.nae2.common.items.patternmultitool.ObjPatternMultiTool;
import co.neeve.nae2.common.tiles.TileReconstructionChamber;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum GuiBridge {
    STUB,
    PATTERN_MULTI_TOOL(ObjPatternMultiTool.class, ContainerPatternMultiTool.class, GuiHostType.ITEM, SecurityPermissions.BUILD),
    RECONSTRUCTION_CHAMBER(TileReconstructionChamber.class, ContainerReconstructionChamber.class, GuiHostType.WORLD, SecurityPermissions.BUILD);

    private static GuiBridge[] cachedValues;
    private final Class<?> clazz;
    private final Class<? extends AEBaseContainer> containerClass;
    private final GuiHostType hostType;
    private final SecurityPermissions securityPermissions;
    @SideOnly(value=Side.CLIENT)
    private Class<? super AEBaseGui> clientGuiClass;

    private GuiBridge(Class<?> clazz, Class<? extends AEBaseContainer> containerClass, GuiHostType hostType, SecurityPermissions securityPermissions) {
        this.hostType = hostType;
        this.securityPermissions = securityPermissions;
        if (!IGuiItemObject.class.isAssignableFrom(clazz) && !AEBaseTile.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Invalid GuiBridge class");
        }
        this.clazz = clazz;
        this.containerClass = containerClass;
        this.getGui();
    }

    private GuiBridge() {
        this.clazz = null;
        this.containerClass = null;
        this.hostType = null;
        this.securityPermissions = null;
    }

    private static GuiBridge[] cachedValues() {
        if (cachedValues == null) {
            cachedValues = GuiBridge.values();
            return cachedValues;
        }
        return cachedValues;
    }

    @Nullable
    public static GuiBridge getByID(int id) {
        if (id < 0 || id > GuiBridge.cachedValues().length) {
            return null;
        }
        return cachedValues[id];
    }

    static Object getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z, AEPartLocation side) {
        if (!it.func_190926_b()) {
            Item item = it.func_77973_b();
            if (item instanceof INAEGuiItem) {
                INAEGuiItem ngi = (INAEGuiItem)item;
                return ngi.getGuiObject(it, w, new BlockPos(x, y, z), side);
            }
            IWirelessTermHandler wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(it);
            if (wh != null) {
                return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
            }
        }
        return null;
    }

    static Object getGuiObject(ItemStack it, World w) {
        Item item;
        if (!it.func_190926_b() && (item = it.func_77973_b()) instanceof INAEGuiItem) {
            INAEGuiItem ngi = (INAEGuiItem)item;
            return ngi.getGuiObject(it, w);
        }
        return null;
    }

    public boolean CorrectTileOrPart(Object tE) {
        if (this.clazz == null) {
            throw new IllegalArgumentException("This Gui Cannot use the standard Handler.");
        }
        return this.clazz.isInstance(tE);
    }

    private void getGui() {
        if (Platform.isClientInstall()) {
            AEBaseGui.class.getName();
            String start = this.containerClass.getName();
            String guiClass = start.replaceFirst("common.containers.Container", "client.gui.implementations.Gui");
            if (start.equals(guiClass)) {
                throw new IllegalStateException("Unable to find gui class");
            }
            this.clientGuiClass = ReflectionHelper.getClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String[])new String[]{guiClass});
        }
    }

    private Constructor<?> findConstructor(Constructor<?>[] constructors, InventoryPlayer inventory, Object tE) {
        for (Constructor<?> con : constructors) {
            Class<?>[] types = con.getParameterTypes();
            if (types.length != 2 || !types[0].isAssignableFrom(inventory.getClass()) || !types[1].isAssignableFrom(tE.getClass())) continue;
            return con;
        }
        return null;
    }

    private String typeName(Object inventory) {
        return inventory == null ? "NULL" : inventory.getClass().getName();
    }

    public Object ConstructContainer(InventoryPlayer inventory, Object tE) {
        try {
            Constructor<?>[] c = this.containerClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor<?> target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public GuiHostType getHostType() {
        return this.hostType;
    }

    public Object ConstructGui(InventoryPlayer inventory, Object tE) {
        try {
            Constructor<?>[] c = this.clientGuiClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor<?> target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public boolean hasPermissions(TileEntity te, int x, int y, int z, AEPartLocation side, EntityPlayer player) {
        World w = player.func_130014_f_();
        BlockPos pos = new BlockPos(x, y, z);
        if (Platform.hasPermissions((DimensionalCoord)(te != null ? new DimensionalCoord(te) : new DimensionalCoord(player.field_70170_p, pos)), (EntityPlayer)player)) {
            Object myItem;
            ItemStack it;
            if (this.hostType.isItem() && !(it = player.field_71071_by.func_70448_g()).func_190926_b() && it.func_77973_b() instanceof INAEGuiItem && this.CorrectTileOrPart(myItem = ((INAEGuiItem)it.func_77973_b()).getGuiObject(it, w, pos, side))) {
                return true;
            }
            if (!this.hostType.isItem()) {
                TileEntity TE = w.func_175625_s(pos);
                if (TE instanceof IPartHost) {
                    ((IPartHost)TE).getPart(side);
                    IPart part = ((IPartHost)TE).getPart(side);
                    if (this.CorrectTileOrPart(part)) {
                        return this.securityCheck(part, player);
                    }
                } else if (this.CorrectTileOrPart(TE)) {
                    return this.securityCheck(TE, player);
                }
            }
        }
        return false;
    }

    private boolean securityCheck(Object te, EntityPlayer player) {
        if (te instanceof IActionHost && this.securityPermissions != null) {
            IGridNode gn = ((IActionHost)te).getActionableNode();
            IGrid g = gn.getGrid();
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            return sg.hasPermission(player, this.securityPermissions);
        }
        return true;
    }
}

