/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.registry.rendering;

import appeng.api.util.AEColor;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.client.render.StaticItemColor;
import co.neeve.nae2.common.items.NAEBaseItemPart;
import co.neeve.nae2.common.registration.definitions.Parts;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPartRendering
extends ItemRenderingCustomizer {
    private static final ModelResourceLocation MODEL_MISSING = new ModelResourceLocation("builtin/missing", "missing");
    private final NAEBaseItemPart item;

    public ItemPartRendering(NAEBaseItemPart item) {
        this.item = item;
    }

    @SideOnly(value=Side.CLIENT)
    public void customize(IItemRendering rendering) {
        rendering.meshDefinition(this::getItemMeshDefinition);
        rendering.color((IItemColor)new StaticItemColor(AEColor.TRANSPARENT));
        rendering.variants((Collection)Arrays.stream(Parts.PartType.values()).filter(Parts.PartType::isEnabled).flatMap(part -> part.getItemModels().stream()).collect(Collectors.toList()));
    }

    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation getItemMeshDefinition(ItemStack is) {
        Parts.PartType partType = this.item.getTypeByStack(is);
        int variant = this.item.variantOf(is.func_77952_i());
        if (partType == null) {
            return MODEL_MISSING;
        }
        return partType.getItemModels().get(variant);
    }
}

