/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.registry;

import appeng.api.definitions.IItemDefinition;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.bootstrap.IBootstrapComponent;
import appeng.core.features.ActivityState;
import appeng.core.features.ColoredItemDefinition;
import appeng.core.features.ItemStackSrc;
import appeng.util.Platform;
import co.neeve.nae2.common.registration.registry.builders.INAEBlockBuilder;
import co.neeve.nae2.common.registration.registry.builders.INAEItemBuilder;
import co.neeve.nae2.common.registration.registry.builders.NAEBlockDefinitionBuilder;
import co.neeve.nae2.common.registration.registry.builders.NAEItemDefinitionBuilder;
import co.neeve.nae2.common.registration.registry.components.NAEBuiltInModelComponent;
import co.neeve.nae2.common.registration.registry.components.NAEModelOverrideComponent;
import co.neeve.nae2.common.registration.registry.components.NAETileEntityComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Registry {
    public final NAETileEntityComponent tileEntityComponent;
    private final Map<Class<? extends IBootstrapComponent>, List<IBootstrapComponent>> bootstrapComponents = new HashMap<Class<? extends IBootstrapComponent>, List<IBootstrapComponent>>();
    @SideOnly(value=Side.CLIENT)
    private NAEModelOverrideComponent modelOverrideComponent;
    @SideOnly(value=Side.CLIENT)
    private NAEBuiltInModelComponent builtInModelComponent;

    public Registry() {
        this.tileEntityComponent = new NAETileEntityComponent();
        this.addBootstrapComponent((IBootstrapComponent)this.tileEntityComponent);
        if (Platform.isClient()) {
            this.modelOverrideComponent = new NAEModelOverrideComponent();
            this.addBootstrapComponent((IBootstrapComponent)this.modelOverrideComponent);
            this.builtInModelComponent = new NAEBuiltInModelComponent();
            this.addBootstrapComponent((IBootstrapComponent)this.builtInModelComponent);
        }
    }

    public INAEBlockBuilder block(String id, Supplier<Block> block) {
        return new NAEBlockDefinitionBuilder(this, id, block);
    }

    public INAEItemBuilder item(String id, Supplier<Item> item) {
        return new NAEItemDefinitionBuilder(this, id, item);
    }

    public AEColoredItemDefinition colored(IItemDefinition target, int offset) {
        ColoredItemDefinition definition = new ColoredItemDefinition();
        target.maybeItem().ifPresent(targetItem -> {
            for (AEColor color : AEColor.VALID_COLORS) {
                ActivityState state = ActivityState.from((boolean)target.isEnabled());
                definition.add(color, new ItemStackSrc(targetItem, offset + color.ordinal(), state));
            }
        });
        return definition;
    }

    public void addBootstrapComponent(IBootstrapComponent component) {
        Arrays.stream(component.getClass().getInterfaces()).filter(IBootstrapComponent.class::isAssignableFrom).forEach(i -> this.addBootstrapComponent((Class<? extends IBootstrapComponent>)i, (IBootstrapComponent)component));
    }

    private <T extends IBootstrapComponent> void addBootstrapComponent(Class<? extends IBootstrapComponent> eventType, T component) {
        this.bootstrapComponents.computeIfAbsent(eventType, c -> new ArrayList()).add(component);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBuiltInModel(String path, IModel model) {
        this.builtInModelComponent.addModel(path, model);
    }

    @SideOnly(value=Side.CLIENT)
    public void addModelOverride(String resourcePath, BiFunction<ModelResourceLocation, IBakedModel, IBakedModel> customizer) {
        this.modelOverrideComponent.addOverride(resourcePath, customizer);
    }

    public <T extends IBootstrapComponent> Iterator<T> getBootstrapComponents(Class<T> eventType) {
        return this.bootstrapComponents.getOrDefault(eventType, Collections.emptyList()).iterator();
    }
}

