/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.recipes.handlers;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.registration.Registration;
import co.neeve.nae2.common.registration.definitions.Blocks;
import co.neeve.nae2.common.registration.definitions.Items;
import co.neeve.nae2.common.registration.definitions.Materials;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public final class DisassembleRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final ItemStack MISMATCHED_STACK = ItemStack.field_190927_a;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;

    public DisassembleRecipe() {
        Registration definitions = NAE2.definitions();
        Blocks blocks = definitions.blocks();
        Items items = definitions.items();
        Materials mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(6);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(4);
        this.cellMappings.put(items.storageCell256K(), mats.cellPart256K());
        this.cellMappings.put(items.storageCell1024K(), mats.cellPart1024K());
        this.cellMappings.put(items.storageCell4096K(), mats.cellPart4096K());
        this.cellMappings.put(items.storageCell16384K(), mats.cellPart16384K());
        this.cellMappings.put(items.storageCellFluid256K(), mats.cellPart256K());
        this.cellMappings.put(items.storageCellFluid1024K(), mats.cellPart1024K());
        this.cellMappings.put(items.storageCellFluid4096K(), mats.cellPart4096K());
        this.cellMappings.put(items.storageCellFluid16384K(), mats.cellPart16384K());
        this.nonCellMappings.put((IItemDefinition)blocks.storageCrafting256K(), mats.cellPart256K());
        this.nonCellMappings.put((IItemDefinition)blocks.storageCrafting1024K(), mats.cellPart1024K());
        this.nonCellMappings.put((IItemDefinition)blocks.storageCrafting4096K(), mats.cellPart4096K());
        this.nonCellMappings.put((IItemDefinition)blocks.storageCrafting16384K(), mats.cellPart16384K());
    }

    private static <T extends IAEStack<T>> IItemList<T> getStorageList(ItemStack stack) {
        IStorageCell item = (IStorageCell)stack.func_77973_b();
        IStorageChannel channel = item.getChannel();
        ICellInventoryHandler cellInv = AEApi.instance().registries().cell().getCellInventory(stack, null, channel);
        assert (cellInv != null);
        return cellInv.getAvailableItems(channel.createList());
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @NotNull World w) {
        ItemStack output = this.getOutput((IInventory)inv);
        return output != null && !output.func_190926_b();
    }

    private ItemStack getOutput(IInventory inventory) {
        int itemCount = 0;
        ItemStack output = MISMATCHED_STACK;
        for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (++itemCount > 1) {
                return MISMATCHED_STACK;
            }
            Optional<ItemStack> maybeCellOutput = this.getCellOutput(stackInSlot);
            if (maybeCellOutput.isPresent()) {
                ItemStack storageCellStack = maybeCellOutput.get();
                IItemList storageList = DisassembleRecipe.getStorageList(stackInSlot);
                if (!storageList.isEmpty()) {
                    return MISMATCHED_STACK;
                }
                output = storageCellStack;
            }
            output = this.getNonCellOutput(stackInSlot).orElse(output);
        }
        return output;
    }

    @Nonnull
    private Optional<ItemStack> getCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<ItemStack> getNonCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.empty();
    }

    @Nonnull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        return this.getOutput((IInventory)inv);
    }

    public boolean func_194133_a(int i, int i1) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }
}

