/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.parts.p2p.iface;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.IInterfaceHost;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import co.neeve.nae2.common.helpers.inv.IDelegate;
import co.neeve.nae2.common.parts.p2p.PartP2PInterface;
import co.neeve.nae2.common.parts.p2p.iface.CapabilityContainer;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterfaceTunnelGridCache
implements IGridCache {
    private final IGrid grid;
    protected Map<Short, CapabilityContainer> containerMap = new MapMaker().weakValues().makeMap();
    protected WeakHashMap<PartP2PInterface, HashSet<Object>> tunnelCapCache = new WeakHashMap();

    public InterfaceTunnelGridCache(IGrid grid) {
        this.grid = grid;
    }

    public static boolean isInterface(Object te, EnumFacing facing) {
        if (te instanceof IInterfaceHost) {
            return true;
        }
        if (te instanceof IFluidInterfaceHost) {
            return true;
        }
        if (te instanceof PartP2PInterface) {
            return true;
        }
        if (te instanceof IPartHost) {
            IPartHost iPartHost = (IPartHost)te;
            IPart part = iPartHost.getPart(facing);
            return InterfaceTunnelGridCache.isInterface(part, facing);
        }
        return false;
    }

    @Nullable
    private static <T> T getCapability(TileEntity tile, Capability<T> capabilityType, EnumFacing facing) {
        if (tile.hasCapability(capabilityType, facing)) {
            Object capability = tile.getCapability(capabilityType, facing);
            if (capability instanceof IDelegate) {
                IDelegate delegate = (IDelegate)capability;
                capability = delegate.getDelegate();
            }
            return (T)capability;
        }
        return null;
    }

    @Nullable
    public CapabilityContainer getCapabilityCacheForFreq(short freq) {
        if (freq == 0) {
            return null;
        }
        if (!this.containerMap.containsKey(freq)) {
            CapabilityContainer container = new CapabilityContainer();
            this.containerMap.put(freq, container);
            return container;
        }
        return this.containerMap.get(freq);
    }

    public void onUpdateTick() {
    }

    public void removeNode(@NotNull IGridNode iGridNode, @NotNull IGridHost iGridHost) {
    }

    public void addNode(@NotNull IGridNode iGridNode, @NotNull IGridHost iGridHost) {
    }

    public void onSplit(@NotNull IGridStorage iGridStorage) {
    }

    public void onJoin(@NotNull IGridStorage iGridStorage) {
    }

    public void populateGridStorage(@NotNull IGridStorage iGridStorage) {
    }

    public void updateTunnelNetwork(short freq) {
        if (freq == 0) {
            return;
        }
        CapabilityContainer cache = this.getCapabilityCacheForFreq(freq);
        if (cache == null) {
            return;
        }
        P2PCache p2pCache = (P2PCache)this.grid.getCache(P2PCache.class);
        TunnelCollection inputs = p2pCache.getInputs(freq, PartP2PInterface.class);
        ArrayList<IItemHandler> itemHandlerList = new ArrayList<IItemHandler>();
        ArrayList<IFluidHandler> fluidHandlerList = new ArrayList<IFluidHandler>();
        for (PartP2PTunnel input : inputs) {
            PartP2PInterface tunnel = (PartP2PInterface)input;
            TileEntity tile = ((PartP2PInterface)input).getFacingTileEntity();
            EnumFacing facing = tunnel.getFacing().func_176734_d();
            HashSet capSet = this.tunnelCapCache.computeIfAbsent(tunnel, k -> new HashSet());
            if (!InterfaceTunnelGridCache.isInterface(tile, facing)) continue;
            Object cap = InterfaceTunnelGridCache.getCapability(tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            if (cap != null && cap != cache) {
                capSet.add(cap);
                itemHandlerList.add((IItemHandler)cap);
            }
            if ((cap = InterfaceTunnelGridCache.getCapability(tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) == null || cap == cache) continue;
            capSet.add(cap);
            fluidHandlerList.add((IFluidHandler)cap);
        }
        cache.setItemHandler(itemHandlerList);
        cache.setFluidHandler(fluidHandlerList);
    }

    public void onNeighborChanged(PartP2PInterface tunnel) {
        HashSet<Object> cacheEntry;
        HashSet newCaps = new HashSet();
        TileEntity tile = tunnel.getFacingTileEntity();
        EnumFacing facing = tunnel.getFacing().func_176734_d();
        CapabilityContainer cache = this.getCapabilityCacheForFreq(tunnel.getFrequency());
        if (InterfaceTunnelGridCache.isInterface(tile, facing)) {
            Object cap = InterfaceTunnelGridCache.getCapability(tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
            if (cap != null && cap != cache) {
                newCaps.add(cap);
            }
            if ((cap = InterfaceTunnelGridCache.getCapability(tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) != null && cap != cache) {
                newCaps.add(cap);
            }
        }
        if ((cacheEntry = this.tunnelCapCache.get((Object)tunnel)) == null || !cacheEntry.equals(newCaps)) {
            this.tunnelCapCache.put(tunnel, newCaps);
            this.updateTunnelNetwork(tunnel.getFrequency());
        }
    }
}

