/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.parts.p2p.iface;

import appeng.util.inv.WrapperChainedItemHandler;
import co.neeve.nae2.common.helpers.inv.WrapperChainedFluidHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;

public class CapabilityContainer
implements IItemHandler,
IFluidHandler,
ICapabilityProvider {
    public static final IFluidTankProperties[] NONE = new IFluidTankProperties[0];
    protected IItemHandler itemHandler = EmptyHandler.INSTANCE;
    protected IFluidHandler fluidHandler = EmptyFluidHandler.INSTANCE;
    protected boolean isViewing = false;

    public IFluidTankProperties[] getTankProperties() {
        if (this.isViewing) {
            return NONE;
        }
        this.isViewing = true;
        try {
            IFluidTankProperties[] iFluidTankPropertiesArray = this.fluidHandler.getTankProperties();
            return iFluidTankPropertiesArray;
        }
        finally {
            this.isViewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(FluidStack resource, boolean doFill) {
        if (this.isViewing) {
            return 0;
        }
        this.isViewing = true;
        try {
            int n = this.fluidHandler.fill(resource, doFill);
            return n;
        }
        finally {
            this.isViewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.isViewing) {
            return null;
        }
        this.isViewing = true;
        try {
            FluidStack fluidStack = this.fluidHandler.drain(resource, doDrain);
            return fluidStack;
        }
        finally {
            this.isViewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.isViewing) {
            return null;
        }
        this.isViewing = true;
        try {
            FluidStack fluidStack = this.fluidHandler.drain(maxDrain, doDrain);
            return fluidStack;
        }
        finally {
            this.isViewing = false;
        }
    }

    public int getSlots() {
        if (this.isViewing) {
            return 0;
        }
        this.isViewing = true;
        try {
            int n = this.itemHandler.getSlots();
            return n;
        }
        finally {
            this.isViewing = false;
        }
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.isViewing) {
            return ItemStack.field_190927_a;
        }
        this.isViewing = true;
        try {
            ItemStack itemStack = this.itemHandler.getStackInSlot(slot);
            return itemStack;
        }
        finally {
            this.isViewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.isViewing) {
            return ItemStack.field_190927_a;
        }
        this.isViewing = true;
        try {
            ItemStack itemStack = this.itemHandler.insertItem(slot, stack, simulate);
            return itemStack;
        }
        finally {
            this.isViewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isViewing) {
            return ItemStack.field_190927_a;
        }
        this.isViewing = true;
        try {
            ItemStack itemStack = this.itemHandler.extractItem(slot, amount, simulate);
            return itemStack;
        }
        finally {
            this.isViewing = false;
        }
    }

    public int getSlotLimit(int slot) {
        if (this.isViewing) {
            return 0;
        }
        this.isViewing = true;
        try {
            int n = this.itemHandler.getSlotLimit(slot);
            return n;
        }
        finally {
            this.isViewing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (this.isViewing) {
            return false;
        }
        this.isViewing = true;
        try {
            boolean bl = this.itemHandler.isItemValid(slot, stack);
            return bl;
        }
        finally {
            this.isViewing = false;
        }
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void setItemHandler(List<IItemHandler> itemHandler) {
        this.setItemHandler(itemHandler.toArray(new IItemHandler[0]));
    }

    public void setItemHandler(IItemHandler[] itemHandlers) {
        this.itemHandler = new WrapperChainedItemHandler(itemHandlers);
    }

    public void setFluidHandler(List<IFluidHandler> fluidHandler) {
        this.setFluidHandler(fluidHandler.toArray(new IFluidHandler[0]));
    }

    public void setFluidHandler(IFluidHandler[] fluidHandlers) {
        this.fluidHandler = new WrapperChainedFluidHandler(fluidHandlers);
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        return null;
    }
}

