/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import appeng.capabilities.Capabilities;
import appeng.core.settings.TickRates;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.ItemStackHelper;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.parts.misc.PartInterface;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileCableBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import co.neeve.nae2.common.helpers.inv.FluidHandlerDelegate;
import co.neeve.nae2.common.helpers.inv.ItemHandlerDelegate;
import co.neeve.nae2.common.parts.p2p.P2PModels;
import co.neeve.nae2.common.parts.p2p.iface.CapabilityContainer;
import co.neeve.nae2.common.parts.p2p.iface.InterfaceTunnelGridCache;
import co.neeve.nae2.mixin.ifacep2p.shared.DualityAccessor;
import com.glodblock.github.inventory.FluidConvertingInventoryAdaptor;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartP2PInterface
extends PartP2PTunnel<PartP2PInterface>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_interface");
    private final MachineSource mySource;
    private final List<ItemStack> waitingToSend = new ArrayList<ItemStack>();
    private final ItemHandlerDelegate myItemHandlerDelegate = new ItemHandlerDelegate();
    private final FluidHandlerDelegate myFluidHandlerDelegate = new FluidHandlerDelegate();
    private EnumFacing myFacing;
    private boolean requested;
    private ObjectOpenHashSet<PartP2PInterface> cachedOutputs;
    private TileEntity facingTileEntity;
    private boolean isViewing;
    private Collection<PartP2PInterface> cachedOutputsRecursive;

    public PartP2PInterface(ItemStack is) {
        super(is);
        this.mySource = new MachineSource((IActionHost)this);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        if (Platform.isClient()) {
            return;
        }
        this.myFacing = side.getFacing();
    }

    public EnumFacing getFacing() {
        return this.myFacing;
    }

    @NotNull
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public boolean hasItemsToSend() {
        return !this.waitingToSend.isEmpty();
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagList waitingToSend = new NBTTagList();
        for (ItemStack is : this.waitingToSend) {
            NBTTagCompound itemNBT = ItemStackHelper.stackToNBT((ItemStack)is);
            waitingToSend.func_74742_a((NBTBase)itemNBT);
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        for (int x = 0; x < waitingList.func_74745_c(); ++x) {
            NBTTagCompound up = waitingList.func_150305_b(x);
            ItemStack is = ItemStackHelper.stackFromNBT((NBTTagCompound)up);
            this.addToSendList(is);
        }
    }

    public void addToSendList(ItemStack is) {
        if (!is.func_190926_b()) {
            this.waitingToSend.add(is);
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        int min = Math.min(TickRates.ItemTunnel.getMin(), TickRates.Interface.getMin());
        int max = Math.max(TickRates.ItemTunnel.getMax(), TickRates.Interface.getMax());
        return new TickingRequest(min, max, false, false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        boolean wasReq = this.requested;
        this.requested = false;
        TickRateModulation reqResult = wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        boolean pushWorked = false;
        if (this.hasItemsToSend()) {
            pushWorked = this.pushItemsOut();
        }
        if (this.hasItemsToSend()) {
            return pushWorked ? TickRateModulation.URGENT : reqResult;
        }
        return reqResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pushItemsOut() {
        boolean worked = false;
        if (this.waitingToSend.isEmpty()) return worked;
        EnumFacing s = this.myFacing;
        TileEntity tile = this.getTile();
        World w = tile.func_145831_w();
        TileEntity target = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
        if (target == null) return worked;
        if (target instanceof IInterfaceHost || target instanceof TileCableBus && ((TileCableBus)target).getPart(s.func_176734_d()) instanceof PartInterface) {
            try {
                IMEMonitor inv;
                IStorageMonitorable sm;
                IStorageMonitorableAccessor mon;
                IInterfaceHost targetTE = target instanceof IInterfaceHost ? (IInterfaceHost)target : (IInterfaceHost)((TileCableBus)target).getPart(s.func_176734_d());
                DualityAccessor dualityAccessor = (DualityAccessor)targetTE.getInterfaceDuality();
                if (dualityAccessor.invokeSameGrid(this.getGridNode().getGrid()) || (mon = (IStorageMonitorableAccessor)target.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, s.func_176734_d())) == null || (sm = mon.getInventory((IActionSource)this.mySource)) == null || !Platform.canAccess((AENetworkProxy)dualityAccessor.getGridProxy(), (IActionSource)this.mySource) || (inv = sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))) == null) return worked;
                Iterator<ItemStack> i = this.waitingToSend.iterator();
                while (i.hasNext()) {
                    ItemStack whatToSend = i.next();
                    IAEItemStack result = (IAEItemStack)inv.injectItems((IAEStack)AEItemStack.fromItemStack((ItemStack)whatToSend), Actionable.MODULATE, (IActionSource)this.mySource);
                    if (result != null) {
                        if ((long)whatToSend.func_190916_E() != result.getStackSize()) {
                            worked = true;
                        }
                        whatToSend.func_190920_e((int)result.getStackSize());
                        whatToSend.func_77982_d(result.getDefinition().func_77978_p());
                        continue;
                    }
                    worked = true;
                    i.remove();
                }
                return worked;
            }
            catch (GridAccessException var12) {
                throw new RuntimeException(var12);
            }
        } else {
            InventoryAdaptor ad = Platform.isModLoaded((String)"ae2fc") ? FluidConvertingInventoryAdaptor.wrap((ICapabilityProvider)target, (EnumFacing)s.func_176734_d()) : InventoryAdaptor.getAdaptor((TileEntity)target, (EnumFacing)s.func_176734_d());
            Iterator<ItemStack> i = this.waitingToSend.iterator();
            while (i.hasNext()) {
                ItemStack whatToSend = i.next();
                if (ad == null) continue;
                ItemStack result = ad.addItems(whatToSend);
                if (!result.func_190926_b()) {
                    if (whatToSend.func_190916_E() != result.func_190916_E()) {
                        worked = true;
                    }
                    whatToSend.func_190920_e(result.func_190916_E());
                    whatToSend.func_77982_d(result.func_77978_p());
                    continue;
                }
                worked = true;
                i.remove();
            }
        }
        return worked;
    }

    @Nullable
    public TunnelCollection<PartP2PInterface> getOutputs() {
        try {
            return super.getOutputs();
        }
        catch (GridAccessException ignored) {
            return null;
        }
    }

    @Nullable
    public TunnelCollection<PartP2PInterface> getInputs() {
        try {
            return super.getInputs();
        }
        catch (GridAccessException ignored) {
            return null;
        }
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        drops.addAll(this.waitingToSend);
    }

    @Nullable
    public TileEntity getFacingTileEntity() {
        if (this.facingTileEntity == null) {
            try {
                TileEntity tile = this.getTile();
                this.facingTileEntity = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(this.myFacing));
            }
            catch (NullPointerException ignored) {
                return null;
            }
        }
        return this.facingTileEntity;
    }

    public boolean isValidDestination(PartP2PInterface tunnel) {
        return this.getCachedOutputsRecursive().contains((Object)tunnel);
    }

    public ObjectOpenHashSet<PartP2PInterface> getCachedOutputs() {
        if (this.cachedOutputs == null) {
            TunnelCollection<PartP2PInterface> outputs = this.getOutputs();
            if (outputs != null) {
                this.cachedOutputs = new ObjectOpenHashSet(outputs.size());
                outputs.forEach(arg_0 -> this.cachedOutputs.add(arg_0));
            } else {
                this.cachedOutputs = new ObjectOpenHashSet();
            }
        }
        return this.cachedOutputs;
    }

    public Collection<PartP2PInterface> getCachedOutputsRecursive() {
        if (this.cachedOutputsRecursive == null) {
            this.cachedOutputsRecursive = new ObjectOpenHashSet();
            this.getOutputsRecursive(this.cachedOutputsRecursive);
        }
        return this.cachedOutputsRecursive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOutputsRecursive(Collection<PartP2PInterface> collection) {
        if (this.isViewing) {
            return;
        }
        this.isViewing = true;
        try {
            if (!this.isOutput()) {
                ObjectOpenHashSet<PartP2PInterface> outputs = this.getCachedOutputs();
                for (PartP2PInterface output : outputs) {
                    PartP2PInterface ifacep2p;
                    IPartHost partHost;
                    IPart iPart;
                    EnumFacing opposite = output.getFacing().func_176734_d();
                    TileEntity te = output.getFacingTileEntity();
                    if (te == null) continue;
                    if (te instanceof IPartHost && (iPart = (partHost = (IPartHost)te).getPart(opposite)) instanceof PartP2PInterface && !(ifacep2p = (PartP2PInterface)iPart).isOutput()) {
                        ifacep2p.getOutputsRecursive(collection);
                        continue;
                    }
                    collection.add(output);
                }
            }
        }
        finally {
            this.isViewing = false;
        }
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        IGridNode node = this.getGridNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        IGridCache cache = grid.getCache(InterfaceTunnelGridCache.class);
        if (cache == null) {
            return;
        }
        ((InterfaceTunnelGridCache)cache).onNeighborChanged(this);
        this.cachedOutputsRecursive = null;
    }

    public void onTunnelNetworkChange() {
        if (Platform.isClient()) {
            return;
        }
        this.cachedOutputs = null;
        this.facingTileEntity = null;
        this.cachedOutputsRecursive = null;
        InterfaceTunnelGridCache cache = (InterfaceTunnelGridCache)this.getGridNode().getGrid().getCache(InterfaceTunnelGridCache.class);
        CapabilityContainer capabilityContainer = cache.getCapabilityCacheForFreq(this.getFrequency());
        this.myItemHandlerDelegate.setDelegate(capabilityContainer);
        this.myFluidHandlerDelegate.setDelegate(capabilityContainer);
        this.getHost().notifyNeighbors();
    }

    public boolean hasCapability(Capability<?> capabilityClass) {
        return capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.myItemHandlerDelegate;
        }
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.myFluidHandlerDelegate;
        }
        return (T)super.getCapability(capabilityClass);
    }
}

