/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.parts.implementations;

import appeng.api.networking.GridFlags;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartBasicState;
import appeng.parts.PartModel;
import appeng.util.Platform;
import co.neeve.nae2.common.helpers.exposer.ExposerBootstrapper;
import co.neeve.nae2.common.interfaces.IExposerHost;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartExposer
extends PartBasicState
implements IExposerHost {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("nae2", "part/exposer");
    @PartModels
    private static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/interface_off")});
    @PartModels
    private static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/interface_on")});
    @PartModels
    private static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/interface_has_channel")});
    @Nullable
    private ExposerBootstrapper exposer;
    private EnumFacing facing;

    public PartExposer(ItemStack is) {
        super(is);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        return this.isPowered() ? MODELS_ON : MODELS_OFF;
    }

    public void addToWorld() {
        super.addToWorld();
        if (Platform.isServer()) {
            this.facing = this.getSide().getFacing();
            this.exposer = new ExposerBootstrapper(this, EnumSet.of(this.facing));
            Platform.notifyBlocksOfNeighbors((World)this.getTile().func_145831_w(), (BlockPos)this.getTile().func_174877_v());
        }
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        return this.exposer != null ? (T)this.exposer.getCapability(capabilityClass, this.facing) : null;
    }

    public boolean hasCapability(Capability<?> capabilityClass) {
        return this.exposer != null && this.exposer.hasCapability(capabilityClass, this.facing);
    }

    @Override
    public ExposerBootstrapper getExposerBootstrapper() {
        return this.exposer;
    }
}

