/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.items.cells.vc;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import co.neeve.nae2.common.features.subfeatures.VoidCellFeatures;
import co.neeve.nae2.common.items.cells.vc.VoidCell;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Nullable;

public class VoidCellInventory<T extends IAEStack<T>>
implements ICellInventoryHandler<T> {
    protected final IStorageChannel<T> channel;
    protected final ItemStack itemStack;
    protected final IItemList<T> itemListCache;
    protected final VoidCell<T> item;
    protected final CellConfig cellConfig;
    protected final ISaveProvider saveProvider;
    protected boolean hasSticky;
    protected boolean hasInverter;
    protected boolean hasFuzzy;

    public VoidCellInventory(ItemStack o, ISaveProvider iSaveProvider) {
        this.itemStack = o;
        this.item = (VoidCell)o.func_77973_b();
        this.channel = this.item.getStorageChannel();
        this.itemListCache = this.getChannel().createList();
        this.saveProvider = iSaveProvider;
        this.cellConfig = this.item.getCellConfig(o);
        for (ItemStack is : this.cellConfig) {
            T aeStack;
            if (is.func_190926_b() || (aeStack = this.item.handleConfigStack(is)) == null) continue;
            this.itemListCache.add(aeStack);
        }
        CellUpgrades upgrades = this.item.getUpgradesInventory(this.itemStack);
        block6: for (int x = 0; x < upgrades.getSlots(); ++x) {
            Upgrades u;
            ItemStack is = upgrades.getStackInSlot(x);
            if (is.func_190926_b() || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
            switch (u) {
                case FUZZY: {
                    this.hasFuzzy = true;
                    continue block6;
                }
                case INVERTER: {
                    this.hasInverter = true;
                    continue block6;
                }
                case STICKY: {
                    this.hasSticky = true;
                }
            }
        }
    }

    public T injectItems(T input, Actionable mode, IActionSource src) {
        if (!this.isValidInput(input)) {
            return input;
        }
        if (mode == Actionable.MODULATE) {
            this.item.addCondenserPowerFromInput(this.itemStack, input.getStackSize());
        }
        return null;
    }

    private boolean isValidInput(T input) {
        if (this.itemListCache.isEmpty()) {
            return true;
        }
        if (this.item.getUpgradesInventory(this.itemStack).getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            return !this.itemListCache.findFuzzy(input, this.item.getFuzzyMode(this.itemStack)).isEmpty();
        }
        return this.itemListCache.findPrecise(input) != null;
    }

    public T extractItems(T request, Actionable mode, IActionSource src) {
        return null;
    }

    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return out;
    }

    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    public boolean isPrioritized(T input) {
        return this.itemListCache.isEmpty() || this.isValidInput(input);
    }

    public boolean canAccept(T input) {
        return this.itemListCache.isEmpty() || this.isValidInput(input);
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    @Nullable
    public ICellInventory<T> getCellInv() {
        return null;
    }

    public boolean isPreformatted() {
        return !this.itemListCache.isEmpty();
    }

    public boolean isFuzzy() {
        return this.hasFuzzy;
    }

    public IncludeExclude getIncludeExcludeMode() {
        return this.hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
    }

    public boolean isSticky() {
        return this.hasSticky;
    }

    public FuzzyMode getFuzzyMode() {
        String fz = Platform.openNbtData((ItemStack)this.itemStack).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable var4) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)this.itemStack).func_74778_a("FuzzyMode", fzMode.name());
    }

    public void addCondenserPowerFromInput(double power) {
        if (!VoidCellFeatures.CONDENSER_POWER.isEnabled()) {
            return;
        }
        this.setCondenserPower(this.getCondenserPower() + power / (double)this.getChannel().transferFactor());
    }

    public double getCondenserPower() {
        if (!VoidCellFeatures.CONDENSER_POWER.isEnabled()) {
            return 0.0;
        }
        NBTTagCompound compound = this.itemStack.func_77978_p();
        if (compound != null) {
            return compound.func_74769_h("power");
        }
        return 0.0;
    }

    public void setCondenserPower(double power) {
        if (!VoidCellFeatures.CONDENSER_POWER.isEnabled()) {
            return;
        }
        NBTTagCompound compound = this.itemStack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            this.itemStack.func_77982_d(compound);
        }
        compound.func_74780_a("power", power);
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges(null);
        }
    }
}

