/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.integration.jei;

import appeng.api.AEApi;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.render.StackSizeRenderer;
import appeng.fluids.client.render.FluidStackSizeRenderer;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import co.neeve.nae2.common.integration.jei.IRecipeCategoryWithOverlay;
import co.neeve.nae2.common.integration.jei.SingleStackRecipe;
import com.google.common.collect.ImmutableList;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import mezz.jei.Internal;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class JEICellCategory
implements IRecipeCategory<SingleStackRecipe>,
IRecipeCategoryWithOverlay {
    public static final String UID = "nae2:cell_view";
    public static final int CELL_SIZE = 18;
    public static final int SLOT_SIZE = 16;
    private static final int WIDTH = 168;
    private static final int GRID_HEIGHT = 126;
    private static final int TOTAL_HEIGHT = 132 + (int)((double)((Minecraft.func_71410_x().field_71466_p.field_78288_b + 2) * 2) * 0.85);
    private final IDrawableStatic slotSprite;
    private final StackSizeRenderer stackSizeRenderer = new StackSizeRenderer();
    private final FluidStackSizeRenderer fluidStackSizeRenderer = new FluidStackSizeRenderer();
    private final Int2ObjectOpenHashMap<ExtendedStackInfo<? extends IAEStack<?>>> extendedStacks = new Int2ObjectOpenHashMap();
    private final IDrawableStatic background;
    private final ObjectArrayList<Point> slotBackgroundXYs = new ObjectArrayList();
    private IDrawable icon = null;
    private CellInfo<? extends IAEStack<?>> cellInfo;

    public JEICellCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(168, TOTAL_HEIGHT);
        this.slotSprite = guiHelper.drawableBuilder(new ResourceLocation("nae2", "textures/gui/slot.png"), 0, 0, 18, 18).setTextureSize(18, 18).build();
        AEApi.instance().definitions().items().cell64k().maybeStack(1).ifPresent(stack -> {
            this.icon = guiHelper.createDrawableIngredient(stack);
        });
    }

    private static <T extends IAEStack<T>> IItemList<T> getAvailableItems(CellInfo<T> cellInfo) {
        return ((CellInfo)cellInfo).cellInv.getAvailableItems(((CellInfo)cellInfo).channel.createList());
    }

    private static String getStorageChannelUnits(IStorageChannel<?> storageChannel) {
        if (storageChannel instanceof IItemStorageChannel) {
            return "items";
        }
        if (storageChannel instanceof IFluidStorageChannel) {
            return "buckets";
        }
        if (Platform.isModLoaded((String)"mekeng") && storageChannel instanceof IGasStorageChannel) {
            return "buckets";
        }
        return "units";
    }

    public static <T extends IAEStack<T>> CellInfo<T> getCellInfo(ItemStack is) {
        if (!(is.func_77973_b() instanceof IStorageCell)) {
            return null;
        }
        IStorageCell storageCell = (IStorageCell)is.func_77973_b();
        ICellHandler handler = AEApi.instance().registries().cell().getHandler(is);
        if (handler == null) {
            return null;
        }
        IStorageChannel channel = storageCell.getChannel();
        ICellInventoryHandler inventory = handler.getCellInventory(is, null, channel);
        if (inventory == null) {
            return null;
        }
        ICellInventory cellInv = inventory.getCellInv();
        if (cellInv == null) {
            return null;
        }
        return new CellInfo(channel, cellInv);
    }

    @NotNull
    public String getUid() {
        return UID;
    }

    @NotNull
    public String getTitle() {
        return I18n.func_135052_a((String)"nae2.jei.cellview", (Object[])new Object[0]);
    }

    @NotNull
    public String getModName() {
        return "Neeve's AE2: Extended Life Additions";
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayout recipeLayout, @NotNull SingleStackRecipe recipeWrapper, @NotNull IIngredients ingredients) {
        this.cellInfo = null;
        this.extendedStacks.clear();
        this.slotBackgroundXYs.clear();
        ItemStack stack = recipeWrapper.stack();
        this.cellInfo = JEICellCategory.getCellInfo(stack);
        if (this.cellInfo == null) {
            return;
        }
        ArrayList storedStacks = new ArrayList();
        JEICellCategory.getAvailableItems(this.cellInfo).forEach(storedStacks::add);
        storedStacks.sort((a, b) -> Math.toIntExact(b.getStackSize() - a.getStackSize()));
        int totalTypes = (int)((CellInfo)this.cellInfo).cellInv.getTotalItemTypes();
        int gridWidth = Math.min(9, totalTypes);
        int gridStartY = TOTAL_HEIGHT - 126;
        int gridStartX = 84 - gridWidth * 18 / 2;
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        Iterator iter = storedStacks.iterator();
        for (int i = 0; i < totalTypes; ++i) {
            int posX = gridStartX + 18 * (i % 9);
            int posY = gridStartY + 18 * (i / 9);
            if (iter.hasNext()) {
                IAEStack aeStack = (IAEStack)iter.next();
                IIngredientRenderer renderer = Internal.getIngredientRegistry().getIngredientRenderer((Object)stack);
                stacks.init(i, true, renderer, posX, posY, 18, 18, (this.slotSprite.getWidth() - 16) / 2, (this.slotSprite.getHeight() - 16) / 2);
                stacks.set(i, aeStack.asItemStackRepresentation());
                stacks.addTooltipCallback(this.getCallBack(this.cellInfo));
                this.extendedStacks.put(i, new ExtendedStackInfo(aeStack, posX, posY));
            }
            this.slotBackgroundXYs.add((Object)new Point(posX, posY));
        }
    }

    public void drawExtras(@NotNull Minecraft minecraft) {
        super.drawExtras(minecraft);
        if (this.cellInfo != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)0.85);
            int offset = 3;
            int fontHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b;
            NumberFormat format = NumberFormat.getInstance();
            long storedItemCount = ((CellInfo)this.cellInfo).cellInv.getStoredItemCount();
            int transferFactor = this.getTransferFactor();
            long capacity = (((CellInfo)this.cellInfo).cellInv.getRemainingItemCount() + storedItemCount) / (long)transferFactor;
            long byteLoss = (long)((CellInfo)this.cellInfo).cellInv.getBytesPerType() * ((CellInfo)this.cellInfo).cellInv.getStoredItemTypes();
            long capacityLoss = byteLoss * (long)((CellInfo)this.cellInfo).channel.getUnitsPerByte() / (long)transferFactor;
            String unitName = I18n.func_135052_a((String)("nae2.jei.cellview." + JEICellCategory.getStorageChannelUnits(this.cellInfo.channel())), (Object[])new Object[0]);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"nae2.jei.cellview.stored", (Object[])new Object[]{format.format(storedItemCount / (long)transferFactor), format.format(capacity), unitName}), offset, offset, 0);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"nae2.jei.cellview.loss", (Object[])new Object[]{format.format(capacityLoss), unitName}), offset, offset + fontHeight + 2, 0);
            GlStateManager.func_179121_F();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            for (Point bgXY : this.slotBackgroundXYs) {
                this.slotSprite.draw(minecraft, bgXY.x, bgXY.y);
            }
        }
    }

    private int getTransferFactor() {
        int transferFactor = Platform.isModLoaded((String)"mekeng") && ((CellInfo)this.cellInfo).channel instanceof IGasStorageChannel ? 1000 : this.cellInfo.channel().transferFactor();
        return transferFactor;
    }

    @NotNull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.cellInfo != null && mouseX > 0 && mouseY > 0 && mouseX < 168 && mouseY < TOTAL_HEIGHT - 126 - 2) {
            long storedItemTypes = ((CellInfo)this.cellInfo).cellInv.getStoredItemTypes();
            int bytesPerType = ((CellInfo)this.cellInfo).cellInv.getBytesPerType();
            if (bytesPerType > 0 && storedItemTypes > 0L) {
                NumberFormat format = NumberFormat.getInstance();
                long byteLoss = (long)bytesPerType * storedItemTypes;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)I18n.func_135052_a((String)"nae2.jei.cellview.hover.1", (Object[])new Object[]{format.format(storedItemTypes)}));
                builder.add((Object)I18n.func_135052_a((String)"nae2.jei.cellview.hover.2", (Object[])new Object[0]));
                builder.add((Object)"");
                builder.add((Object)I18n.func_135052_a((String)"nae2.jei.cellview.hover.3", (Object[])new Object[]{format.format(bytesPerType), format.format(storedItemTypes), format.format(byteLoss)}));
                return builder.build();
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private <T> ITooltipCallback<T> getCallBack(CellInfo<? extends IAEStack<?>> cellInfo) {
        return (slotIndex, input, ingredient, tooltip) -> {
            if (this.extendedStacks.containsKey(slotIndex)) {
                NumberFormat format = NumberFormat.getInstance();
                long stackSize = ((ExtendedStackInfo)this.extendedStacks.get(slotIndex)).stack().getStackSize();
                String unitName = I18n.func_135052_a((String)("nae2.jei.cellview." + JEICellCategory.getStorageChannelUnits(cellInfo.channel())), (Object[])new Object[0]);
                tooltip.add(I18n.func_135052_a((String)"nae2.jei.cellview.hover.stored", (Object[])new Object[]{format.format((double)stackSize / (double)this.getTransferFactor()), unitName}));
                tooltip.add(I18n.func_135052_a((String)"nae2.jei.cellview.used", (Object[])new Object[]{format.format((double)cellInfo.cellInv().getBytesPerType() + Math.ceil((double)stackSize / (double)cellInfo.channel().getUnitsPerByte()))}));
            }
        };
    }

    @Override
    public void drawOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.extendedStacks.forEach((key, info) -> {
            IAEStack stack = info.stack();
            if (stack instanceof IAEFluidStack) {
                IAEFluidStack aefs = (IAEFluidStack)stack;
                this.fluidStackSizeRenderer.renderStackSize(minecraft.field_71466_p, aefs, offsetX + info.posX(), offsetY + info.posY());
            } else {
                AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack.asItemStackRepresentation());
                if (aeStack == null) {
                    return;
                }
                aeStack.setStackSize(stack.getStackSize());
                this.stackSizeRenderer.renderStackSize(minecraft.field_71466_p, (IAEItemStack)aeStack, offsetX + info.posX(), offsetY + info.posY());
            }
        });
    }

    private static final class CellInfo<T extends IAEStack<T>> {
        private final IStorageChannel<T> channel;
        private final ICellInventory<T> cellInv;

        private CellInfo(IStorageChannel<T> channel, ICellInventory<T> cellInv) {
            this.channel = channel;
            this.cellInv = cellInv;
        }

        public String toString() {
            return "CellInfo[" + "channel=" + this.channel + "," + "cellInv=" + this.cellInv + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
            result = 31 * result + (this.cellInv != null ? this.cellInv.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((CellInfo)arg0).channel, this.channel)) {
                return false;
            }
            return Objects.equals(((CellInfo)arg0).cellInv, this.cellInv);
            {
            }
        }

        public IStorageChannel<T> channel() {
            return this.channel;
        }

        public ICellInventory<T> cellInv() {
            return this.cellInv;
        }
    }

    private static final class ExtendedStackInfo<T extends IAEStack<T>> {
        private final IAEStack<T> stack;
        private final int posX;
        private final int posY;

        private ExtendedStackInfo(IAEStack<T> stack, int posX, int posY) {
            this.stack = stack;
            this.posX = posX;
            this.posY = posY;
        }

        public String toString() {
            return "ExtendedStackInfo[" + "stack=" + this.stack + "," + "posX=" + this.posX + "," + "posY=" + this.posY + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.stack != null ? this.stack.hashCode() : 0);
            result = 31 * result + this.posX;
            result = 31 * result + this.posY;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((ExtendedStackInfo)arg0).stack, this.stack)) {
                return false;
            }
            if (((ExtendedStackInfo)arg0).posX != this.posX) {
                return false;
            }
            return ((ExtendedStackInfo)arg0).posY == this.posY;
            {
            }
        }

        public IAEStack<T> stack() {
            return this.stack;
        }

        public int posX() {
            return this.posX;
        }

        public int posY() {
            return this.posY;
        }
    }
}

