/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.helpers.inv;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class WrapperChainedFluidHandler
implements IFluidHandler {
    private final IFluidHandler[] handlers;
    private IFluidTankProperties[] cachedProperties;
    private int depth;

    public WrapperChainedFluidHandler(IFluidHandler[] array) {
        this.handlers = array;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.depth > 0) {
            return new IFluidTankProperties[0];
        }
        if (this.cachedProperties != null) {
            return this.cachedProperties;
        }
        ++this.depth;
        ArrayList<IFluidTankProperties> properties = new ArrayList<IFluidTankProperties>();
        for (IFluidHandler tank : this.handlers) {
            properties.addAll(Arrays.asList(tank.getTankProperties()));
        }
        --this.depth;
        this.cachedProperties = properties.toArray(new IFluidTankProperties[0]);
        return this.cachedProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.depth == 1) {
            return 0;
        }
        ++this.depth;
        int used = 0;
        for (IFluidHandler handler : this.handlers) {
            FluidStack fs = resource.copy();
            fs.amount -= used;
            if (fs.amount <= 0) break;
            used += handler.fill(fs, doFill);
        }
        --this.depth;
        return used;
    }

    @Nullable
    public FluidStack drain(FluidStack fluid, boolean doDrain) {
        if (this.depth > 0) {
            return null;
        }
        ++this.depth;
        if (fluid.amount > 0) {
            FluidStack resource = fluid.copy();
            FluidStack totalDrained = null;
            for (IFluidHandler handler : this.handlers) {
                FluidStack drain = handler.drain(resource, doDrain);
                if (drain == null) continue;
                if (totalDrained == null) {
                    totalDrained = drain;
                } else {
                    totalDrained.amount += drain.amount;
                }
                resource.amount -= drain.amount;
                if (resource.amount <= 0) break;
            }
            --this.depth;
            return totalDrained;
        }
        --this.depth;
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.depth > 0) {
            return null;
        }
        ++this.depth;
        if (maxDrain == 0) {
            --this.depth;
            return null;
        }
        FluidStack totalDrained = null;
        int toDrain = maxDrain;
        for (IFluidHandler fh : this.handlers) {
            if (totalDrained == null) {
                totalDrained = fh.drain(toDrain, doDrain);
                if (totalDrained != null) {
                    toDrain -= totalDrained.amount;
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.amount = toDrain;
                FluidStack drain = fh.drain(copy, doDrain);
                if (drain != null) {
                    totalDrained.amount += drain.amount;
                    toDrain -= drain.amount;
                }
            }
            if (toDrain <= 0) break;
        }
        --this.depth;
        return totalDrained;
    }
}

