/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.helpers.exposer;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import co.neeve.nae2.common.helpers.ObjectIndexableLinkedOpenHashSet;
import co.neeve.nae2.common.helpers.exposer.ExposerHandler;
import co.neeve.nae2.common.interfaces.IExposerHost;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AEStackExposerHandler<T extends IAEStack<T>>
extends ExposerHandler<T> {
    @NotNull
    protected final ObjectIndexableLinkedOpenHashSet<T> cache = new ObjectIndexableLinkedOpenHashSet();

    public AEStackExposerHandler(IExposerHost host) {
        super(host);
    }

    protected void refreshCache() {
        this.cache.clear();
        IItemList storage = this.getStorageList();
        if (storage != null) {
            for (IAEStack iaestack : storage) {
                if (iaestack.getStackSize() == 0L || !this.canHandleStack(iaestack)) continue;
                this.cache.add(iaestack);
            }
        }
    }

    protected boolean canHandleStack(T stack) {
        return true;
    }

    @Nullable
    protected T pullStackInternal(T stack, boolean simulate) {
        if (!this.cache.isEmpty()) {
            try {
                return (T)Platform.poweredExtraction((IEnergySource)this.getProxy().getEnergy(), this.getMonitor(), stack, (IActionSource)this.getActionSource(), (Actionable)(simulate ? Actionable.SIMULATE : Actionable.MODULATE));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T pullStack(T stack, boolean simulate) {
        if (this.lockRecursion()) {
            return null;
        }
        this.updateMonitor();
        try {
            T t = this.pullStackInternal(stack, simulate);
            return t;
        }
        finally {
            this.unlockRecursion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T pullStackFromSlot(int slot, long maxAmt, boolean simulate) {
        if (this.lockRecursion()) {
            return null;
        }
        try {
            IAEStack stack;
            this.updateMonitor();
            if (slot < this.cache.size() && (stack = (IAEStack)this.cache.getByIndex(slot)) != null) {
                if (slot > 0 && !simulate) {
                    this.cache.makeFirst(stack);
                }
                IAEStack iAEStack = this.pullStackInternal(stack.copy().setStackSize(maxAmt), simulate);
                return (T)iAEStack;
            }
            T t = null;
            return t;
        }
        finally {
            this.unlockRecursion();
        }
    }

    @Override
    public void postChange(IBaseMonitor<T> iBaseMonitor, Iterable<T> iterable, IActionSource iActionSource) {
        IItemList storage = this.getStorageList();
        if (storage == null) {
            return;
        }
        for (IAEStack stack : iterable) {
            this.cache.remove(stack);
            IAEStack stackInNetwork = storage.findPrecise(stack);
            if (stackInNetwork == null || stackInNetwork.getStackSize() <= 0L || !this.canHandleStack(stackInNetwork)) continue;
            this.cache.add(stackInNetwork);
        }
    }

    @Override
    public void onListUpdate() {
        this.refreshCache();
    }

    @Override
    protected void onMonitorChange(IMEMonitor<T> oldValue, IMEMonitor<T> newValue) {
        this.refreshCache();
    }

    @NotNull
    public ObjectIndexableLinkedOpenHashSet<T> getCache() {
        return this.cache;
    }

    @Nullable
    protected T getInSlot(int slot) {
        if (this.lockRecursion()) {
            return null;
        }
        try {
            this.updateMonitor();
            if (!this.cache.isEmpty() && slot < this.cache.size()) {
                IAEStack iAEStack = (IAEStack)this.cache.getByIndex(slot);
                return (T)iAEStack;
            }
            T t = null;
            return t;
        }
        finally {
            this.unlockRecursion();
        }
    }
}

