/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.features;

import appeng.util.Platform;
import co.neeve.nae2.common.features.IFeature;
import co.neeve.nae2.common.features.subfeatures.BeamFeatures;
import co.neeve.nae2.common.features.subfeatures.DenseCellFeatures;
import co.neeve.nae2.common.features.subfeatures.ISubFeature;
import co.neeve.nae2.common.features.subfeatures.JEIFeatures;
import co.neeve.nae2.common.features.subfeatures.PatternMultiToolFeatures;
import co.neeve.nae2.common.features.subfeatures.UpgradeFeatures;
import co.neeve.nae2.common.features.subfeatures.VoidCellFeatures;
import java.util.EnumSet;
import javax.annotation.Nullable;

public enum Features implements IFeature
{
    PATTERN_MULTI_TOOL(EnumSet.allOf(PatternMultiToolFeatures.class)),
    VOID_CELLS(EnumSet.allOf(VoidCellFeatures.class), "void"),
    BEAM_FORMERS(EnumSet.allOf(BeamFeatures.class), "beam_former"),
    JEI_HOOKS(EnumSet.allOf(JEIFeatures.class)){

        @Override
        public boolean isEnabled() {
            return Platform.isModLoaded((String)"jei") && super.isEnabled();
        }
    }
    ,
    INTERFACE_P2P{

        @Override
        public String[] getMixins() {
            String[] stringArray;
            if (Platform.isModLoaded((String)"ae2fc")) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "ifacep2p";
                stringArray = stringArray2;
                stringArray2[1] = "ifacep2p.ae2fc";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "ifacep2p";
            }
            return stringArray;
        }
    }
    ,
    UPGRADES(EnumSet.allOf(UpgradeFeatures.class), "upgrades"),
    RECONSTRUCTION_CHAMBER("reconchamber"){

        @Override
        public boolean isEnabled() {
            return Platform.isModLoaded((String)"actuallyadditions") && super.isEnabled();
        }
    }
    ,
    DENSE_CELLS(EnumSet.allOf(DenseCellFeatures.class)),
    DENSE_GAS_CELLS{

        @Override
        public boolean isEnabled() {
            return Platform.isModLoaded((String)"mekeng") && super.isEnabled();
        }
    }
    ,
    DENSE_CPU_COPROCESSORS("dense.coprocessor"),
    DENSE_FLUID_CELLS,
    EXPOSER;

    private String[] mixins;
    private EnumSet<? extends ISubFeature> subFeatures = null;
    private boolean enabled;

    private Features() {
    }

    private Features(String mixins) {
        this();
        this.mixins = new String[]{mixins};
    }

    private Features(EnumSet<? extends ISubFeature> subFeatures) {
        this.subFeatures = subFeatures;
    }

    private Features(EnumSet<? extends ISubFeature> subFeatures, String mixins) {
        this(subFeatures);
        this.mixins = new String[]{mixins};
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    public EnumSet<? extends ISubFeature> getSubFeatures() {
        return this.subFeatures;
    }

    @Nullable
    public String[] getMixins() {
        return this.mixins;
    }
}

