/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.crafting.patterntransform.transformers;

import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import co.neeve.nae2.common.crafting.patterntransform.transformers.IPatternTransformer;
import co.neeve.nae2.common.interfaces.IExtendedUpgradeInventory;
import co.neeve.nae2.common.registration.definitions.Upgrades;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class GregTechCircuitPatternTransformer
implements IPatternTransformer {
    public static Optional<Integer> getCircuitValueFromDetails(ICraftingPatternDetails details) {
        Optional<IAEItemStack> optCircuit = Arrays.stream(details.getInputs()).filter(Objects::nonNull).filter(ais -> IntCircuitIngredient.isIntegratedCircuit((ItemStack)ais.createItemStack())).findFirst();
        if (!optCircuit.isPresent()) {
            return Optional.empty();
        }
        IAEItemStack circuit = optCircuit.get();
        int config = IntCircuitIngredient.getCircuitConfiguration((ItemStack)circuit.createItemStack());
        return Optional.of(config);
    }

    @NotNull
    protected static IAEItemStack[] filterCircuitsOut(IAEItemStack[] inputs) {
        if (inputs == null) {
            return null;
        }
        return (IAEItemStack[])Arrays.stream(inputs).filter(Objects::nonNull).filter(x -> !IntCircuitIngredient.isIntegratedCircuit((ItemStack)x.createItemStack())).toArray(IAEItemStack[]::new);
    }

    @Override
    public boolean shouldTransform(ICraftingMedium medium, ICraftingPatternDetails details) {
        IExtendedUpgradeInventory naeUpgrades;
        IUpgradeableHost upgradeableHost;
        IItemHandler iItemHandler;
        if (details.isCraftable()) {
            return false;
        }
        Optional<Integer> optCircuit = GregTechCircuitPatternTransformer.getCircuitValueFromDetails(details);
        if (!optCircuit.isPresent()) {
            return false;
        }
        return medium instanceof IUpgradeableHost && (iItemHandler = (upgradeableHost = (IUpgradeableHost)medium).getInventoryByName("upgrades")) instanceof IExtendedUpgradeInventory && (naeUpgrades = (IExtendedUpgradeInventory)iItemHandler).getInstalledUpgrades(Upgrades.UpgradeType.GREGTECH_CIRCUIT) > 0;
    }

    @Override
    public IAEItemStack[] transformInputs(ICraftingMedium medium, ICraftingPatternDetails details, IAEItemStack[] inputs) {
        return GregTechCircuitPatternTransformer.filterCircuitsOut(inputs);
    }
}

