/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.client.rendering.models.crafting;

import co.neeve.nae2.client.rendering.models.crafting.DenseLightBakedModel;
import co.neeve.nae2.common.blocks.BlockDenseCraftingUnit;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class DenseCraftingCubeModel
implements IModel {
    private static final ResourceLocation RING_CORNER = DenseCraftingCubeModel.texture("ring_corner");
    private static final ResourceLocation RING_SIDE_HOR = DenseCraftingCubeModel.texture("ring_side_hor");
    private static final ResourceLocation RING_SIDE_VER = DenseCraftingCubeModel.texture("ring_side_ver");
    private static final ResourceLocation UNIT_BASE = DenseCraftingCubeModel.texture("unit_base");
    private static final ResourceLocation LIGHT_BASE = DenseCraftingCubeModel.texture("light_base");
    private static final ResourceLocation MONITOR_BASE = DenseCraftingCubeModel.texture("monitor_base");
    private static final ResourceLocation MONITOR_LIGHT_DARK = DenseCraftingCubeModel.texture("monitor_light_dark");
    private static final ResourceLocation MONITOR_LIGHT_MEDIUM = DenseCraftingCubeModel.texture("monitor_light_medium");
    private static final ResourceLocation MONITOR_LIGHT_BRIGHT = DenseCraftingCubeModel.texture("monitor_light_bright");
    private static final ResourceLocation COPROCESSOR_4X_LIGHT = DenseCraftingCubeModel.naetexture("coprocessor_4x_light");
    private static final ResourceLocation COPROCESSOR_16X_LIGHT = DenseCraftingCubeModel.naetexture("coprocessor_16x_light");
    private static final ResourceLocation COPROCESSOR_64X_LIGHT = DenseCraftingCubeModel.naetexture("coprocessor_64x_light");
    private static final ResourceLocation STORAGE_256K_LIGHT = DenseCraftingCubeModel.naetexture("crafting_storage_256k_light");
    private static final ResourceLocation STORAGE_1024K_LIGHT = DenseCraftingCubeModel.naetexture("crafting_storage_1024k_light");
    private static final ResourceLocation STORAGE_4096K_LIGHT = DenseCraftingCubeModel.naetexture("crafting_storage_4096k_light");
    private static final ResourceLocation STORAGE_16384K_LIGHT = DenseCraftingCubeModel.naetexture("crafting_storage_16384k_light");
    private final BlockDenseCraftingUnit.DenseCraftingUnitType type;

    public DenseCraftingCubeModel(BlockDenseCraftingUnit.DenseCraftingUnitType type) {
        this.type = type;
    }

    private static TextureAtlasSprite getLightTexture(Function<ResourceLocation, TextureAtlasSprite> textureGetter, BlockDenseCraftingUnit.DenseCraftingUnitType type) {
        TextureAtlasSprite textureAtlasSprite;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case STORAGE_256K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_256K_LIGHT);
                break;
            }
            case STORAGE_1024K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_1024K_LIGHT);
                break;
            }
            case STORAGE_4096K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_4096K_LIGHT);
                break;
            }
            case STORAGE_16384K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_16384K_LIGHT);
                break;
            }
            case COPROCESSOR_4X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_4X_LIGHT);
                break;
            }
            case COPROCESSOR_16X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_16X_LIGHT);
                break;
            }
            case COPROCESSOR_64X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_64X_LIGHT);
            }
        }
        return textureAtlasSprite;
    }

    private static ResourceLocation texture(String name) {
        return new ResourceLocation("appliedenergistics2", "blocks/crafting/" + name);
    }

    private static ResourceLocation naetexture(String name) {
        return new ResourceLocation("nae2", "block/crafting/" + name);
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)RING_CORNER, (Object)RING_SIDE_HOR, (Object)RING_SIDE_VER, (Object)UNIT_BASE, (Object)LIGHT_BASE, (Object)COPROCESSOR_4X_LIGHT, (Object)COPROCESSOR_16X_LIGHT, (Object)COPROCESSOR_64X_LIGHT, (Object)STORAGE_256K_LIGHT, (Object)STORAGE_1024K_LIGHT, (Object)STORAGE_4096K_LIGHT, (Object)STORAGE_16384K_LIGHT, (Object[])new ResourceLocation[]{MONITOR_BASE, MONITOR_LIGHT_DARK, MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT});
    }

    @NotNull
    public IBakedModel bake(@NotNull IModelState state, @NotNull VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite ringCorner = bakedTextureGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = bakedTextureGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = bakedTextureGetter.apply(RING_SIDE_VER);
        return new DenseLightBakedModel(format, ringCorner, ringSideHor, ringSideVer, bakedTextureGetter.apply(LIGHT_BASE), DenseCraftingCubeModel.getLightTexture(bakedTextureGetter, this.type));
    }

    @NotNull
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

