/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.client.rendering.helpers.beamformer.renderers;

import co.neeve.nae2.client.rendering.helpers.BeamFormerRenderHelper;
import co.neeve.nae2.client.rendering.helpers.ShaderManager;
import co.neeve.nae2.client.rendering.helpers.beamformer.IBeamFormerRenderer;
import co.neeve.nae2.client.rendering.helpers.beamformer.renderers.NativeBeamFormerRenderer;
import co.neeve.nae2.client.rendering.helpers.beamformer.setups.ModernBeamBloomSetup;
import co.neeve.nae2.common.interfaces.IBeamFormer;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.IBloomEffect;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public class ModernBeamFormerRenderer
implements IBeamFormerRenderer {
    private final IBeamFormerRenderer nativeRenderer = NativeBeamFormerRenderer.create();
    private final Object setup = new ModernBeamBloomSetup();

    private ModernBeamFormerRenderer() {
    }

    @Nullable
    public static IBeamFormerRenderer create() {
        try {
            Class<?> clazz = Class.forName("gregtech.client.utils.IBloomEffect");
            if (clazz.isInterface()) {
                return new ModernBeamFormerRenderer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static IBloomEffect getPredicate(IBeamFormer partBeamFormer) {
        BlockPos bp = partBeamFormer.getPos();
        int x = bp.func_177958_n();
        int y = bp.func_177956_o();
        int z = bp.func_177952_p();
        BeamFormerRenderHelper.StaticBloomMetadata metadata = BeamFormerRenderHelper.getBloomMetadata(partBeamFormer);
        return (bufferBuilder, ctx) -> {
            float[] rgb = BeamFormerRenderHelper.getColor(partBeamFormer);
            int beamLength = partBeamFormer.getBeamLength();
            double beamLengthHalf = (double)(beamLength + 1) / 2.0;
            if (partBeamFormer.shouldRenderBeam()) {
                BeamFormerRenderHelper.drawCube(bufferBuilder, 0.5 + (double)metadata.dx() * beamLengthHalf + (double)x - ctx.cameraX(), 0.5 + (double)metadata.dy() * beamLengthHalf + (double)y - ctx.cameraY(), 0.5 + (double)metadata.dz() * beamLengthHalf + (double)z - ctx.cameraZ(), beamLength, metadata, rgb);
            }
        };
    }

    @Override
    public boolean shouldRenderDynamic(IBeamFormer partBeamFormer) {
        return ShaderManager.isOptifineShaderPackLoaded();
    }

    @Override
    public void renderDynamic(IBeamFormer partBeamFormer, double x, double y, double z, float partialTicks) {
        if (this.shouldRenderDynamic(partBeamFormer)) {
            this.nativeRenderer.renderDynamic(partBeamFormer, x, y, z, partialTicks);
        }
    }

    @Override
    public void init(IBeamFormer beamFormer) {
        IBloomEffect predicate = ModernBeamFormerRenderer.getPredicate(beamFormer);
        BloomEffectUtil.registerBloomRender((IRenderSetup)((IRenderSetup)this.setup), (BloomType)BloomType.UNITY, (IBloomEffect)predicate, bloomRenderTicket -> beamFormer.isValid());
    }
}

