/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.client.rendering.helpers.beamformer.renderers;

import co.neeve.nae2.client.rendering.helpers.BeamFormerRenderHelper;
import co.neeve.nae2.client.rendering.helpers.beamformer.IBeamFormerRenderer;
import co.neeve.nae2.client.rendering.helpers.beamformer.setups.DeprecatedBeamBloomSetup;
import co.neeve.nae2.common.interfaces.IBeamFormer;
import gregtech.client.utils.BloomEffectUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;

public class DeprecatedBeamFormerRenderer
implements IBeamFormerRenderer {
    private final Object setup = new DeprecatedBeamBloomSetup();

    private DeprecatedBeamFormerRenderer() {
    }

    @Nullable
    public static IBeamFormerRenderer create() {
        try {
            Class<?> clazz = Class.forName("gregtech.client.utils.BloomEffectUtil$IBloomRenderFast");
            if (clazz.isInterface()) {
                return new DeprecatedBeamFormerRenderer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Consumer<BufferBuilder> getPredicate(IBeamFormer partBeamFormer, double x, double y, double z) {
        return bufferBuilder -> {
            BeamFormerRenderHelper.StaticBloomMetadata meta = BeamFormerRenderHelper.getBloomMetadata(partBeamFormer);
            float[] color = BeamFormerRenderHelper.getColor(partBeamFormer);
            int beamLength = partBeamFormer.getBeamLength();
            double beamLengthHalf = (double)(beamLength + 1) / 2.0;
            BeamFormerRenderHelper.drawCube(bufferBuilder, x + 0.5 + (double)meta.dx() * beamLengthHalf, y + 0.5 + (double)meta.dy() * beamLengthHalf, z + 0.5 + (double)meta.dz() * beamLengthHalf, beamLength, meta, color);
        };
    }

    @Override
    public boolean shouldRenderDynamic(IBeamFormer partBeamFormer) {
        return true;
    }

    @Override
    public void renderDynamic(IBeamFormer partBeamFormer, double x, double y, double z, float partialTicks) {
        BloomEffectUtil.requestCustomBloom((BloomEffectUtil.IBloomRenderFast)((BloomEffectUtil.IBloomRenderFast)this.setup), DeprecatedBeamFormerRenderer.getPredicate(partBeamFormer, x, y, z));
    }
}

