/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command;

import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeHelp;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.net.MessageEditNBT;
import com.feed_the_beast.ftbutilities.net.MessageEditNBTRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.server.command.CommandTreeBase;

public class CmdEditNBT
extends CmdTreeBase {
    public static Map<UUID, NBTTagCompound> EDITING = new HashMap<UUID, NBTTagCompound>();

    public CmdEditNBT() {
        super("nbtedit");
        this.addSubcommand((ICommand)new CmdBlock());
        this.addSubcommand((ICommand)new CmdEntity());
        this.addSubcommand((ICommand)new CmdPlayer());
        this.addSubcommand((ICommand)new CmdItem());
        this.addSubcommand((ICommand)new CmdTreeHelp((CommandTreeBase)this));
    }

    private static void addInfo(NBTTagList list, ITextComponent key, ITextComponent value) {
        list.func_74742_a((NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)StringUtils.color((ITextComponent)key, (TextFormatting)TextFormatting.BLUE).func_150258_a(": ").func_150257_a(StringUtils.color((ITextComponent)value, (TextFormatting)TextFormatting.GOLD)))));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            new MessageEditNBTRequest().sendTo(CmdEditNBT.func_71521_c((ICommandSender)sender));
        } else {
            super.func_184881_a(server, sender, args);
        }
    }

    private static class CmdItem
    extends CmdNBT {
        private CmdItem() {
            super("item");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) {
            info.func_74778_a("type", "item");
            return player.func_184586_b(EnumHand.MAIN_HAND).serializeNBT();
        }
    }

    private static class CmdPlayer
    extends CmdNBT {
        private CmdPlayer() {
            super("player");
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("me");
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            ForgePlayer p = CommandUtils.getSelfOrOther((ICommandSender)player, (String[])args, (int)0);
            info.func_74757_a("online", p.isOnline());
            info.func_74778_a("type", "player");
            info.func_186854_a("id", p.getId());
            NBTTagCompound nbt = p.getPlayerNBT();
            nbt.func_82580_o("id");
            NBTTagList list = new NBTTagList();
            CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Name"), (ITextComponent)new TextComponentString(player.func_70005_c_()));
            CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Display Name"), player.func_145748_c_());
            CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("UUID"), (ITextComponent)new TextComponentString(player.func_110124_au().toString()));
            CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("FTBLib Team"), (ITextComponent)new TextComponentString(p.team.getId()));
            info.func_74782_a("text", (NBTBase)list);
            info.func_74778_a("title", ITextComponent.Serializer.func_150696_a((ITextComponent)player.func_145748_c_()));
            return nbt;
        }
    }

    private static class CmdEntity
    extends CmdNBT {
        private CmdEntity() {
            super("entity");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 1);
            int id = CmdEntity.func_175755_a((String)args[0]);
            Entity entity = player.field_70170_p.func_73045_a(id);
            NBTTagCompound nbt = new NBTTagCompound();
            if (entity != null) {
                info.func_74778_a("type", "entity");
                info.func_74768_a("id", id);
                entity.func_189511_e(nbt);
                NBTTagList list = new NBTTagList();
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Class"), (ITextComponent)new TextComponentString(entity.getClass().getName()));
                ResourceLocation key = EntityList.func_191306_a(entity.getClass());
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("ID"), (ITextComponent)new TextComponentString(key == null ? "null" : key.toString()));
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Mod"), (ITextComponent)new TextComponentString(key == null ? "null" : ((ModContainer)Loader.instance().getIndexedModList().get(key.func_110624_b())).getName()));
                info.func_74782_a("text", (NBTBase)list);
                info.func_74778_a("title", ITextComponent.Serializer.func_150696_a((ITextComponent)entity.func_145748_c_()));
            }
            return nbt;
        }
    }

    private static class CmdBlock
    extends CmdNBT {
        private CmdBlock() {
            super("block");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 3);
            BlockPos pos = CmdBlock.func_175757_a((ICommandSender)player, (String[])args, (int)0, (boolean)false);
            if (!player.field_70170_p.func_175667_e(pos)) {
                throw new CommandException("commands.clone.outOfWorld", new Object[0]);
            }
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            NBTTagCompound nbt = new NBTTagCompound();
            if (tile != null) {
                info.func_74778_a("type", "block");
                info.func_74768_a("x", pos.func_177958_n());
                info.func_74768_a("y", pos.func_177956_o());
                info.func_74768_a("z", pos.func_177952_p());
                tile.func_189515_b(nbt);
                nbt.func_82580_o("x");
                nbt.func_82580_o("y");
                nbt.func_82580_o("z");
                info.func_74778_a("id", nbt.func_74779_i("id"));
                nbt.func_82580_o("id");
                NBTTagList list = new NBTTagList();
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Class"), (ITextComponent)new TextComponentString(tile.getClass().getName()));
                ResourceLocation key = TileEntity.func_190559_a(tile.getClass());
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("ID"), (ITextComponent)new TextComponentString(key == null ? "null" : key.toString()));
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Block"), (ITextComponent)new TextComponentString(tile.func_145838_q().getRegistryName().toString()));
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Block Class"), (ITextComponent)new TextComponentString(tile.func_145838_q().getClass().getName()));
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Position"), (ITextComponent)new TextComponentString("[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]"));
                ModContainer mod = key == null ? null : (ModContainer)Loader.instance().getIndexedModList().get(key.func_110624_b());
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Mod"), (ITextComponent)new TextComponentString(mod == null ? "null" : mod.getName()));
                CmdEditNBT.addInfo(list, (ITextComponent)new TextComponentString("Ticking"), (ITextComponent)new TextComponentString(tile instanceof ITickable ? "true" : "false"));
                info.func_74782_a("text", (NBTBase)list);
                ITextComponent title = tile.func_145748_c_();
                if (title == null) {
                    title = new TextComponentString(tile.getClass().getSimpleName());
                }
                info.func_74778_a("title", ITextComponent.Serializer.func_150696_a((ITextComponent)title));
            }
            return nbt;
        }
    }

    public static class CmdNBT
    extends CmdBase {
        private CmdNBT(String id) {
            super(id, CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            NBTTagCompound info;
            EntityPlayerMP player = CmdNBT.func_71521_c((ICommandSender)sender);
            NBTTagCompound nbt = this.editNBT(player, info = new NBTTagCompound(), args);
            long size = NBTUtils.getSizeInBytes((NBTTagCompound)nbt, (boolean)false);
            if (size >= 30000L) {
                throw FTBUtilities.error(sender, "commands.nbtedit.too_large", new Object[0]);
            }
            if (info.func_74764_b("type")) {
                info.func_74772_a("random", MathUtils.RAND.nextLong());
                EDITING.put(player.func_146103_bH().getId(), info);
                new MessageEditNBT(info, nbt).sendTo(player);
            }
        }

        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            return new NBTTagCompound();
        }
    }
}

